/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.block.IMicroGrid;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.EntityLightEngine;
import frostnox.nightfall.client.gui.screen.AttributeSelectionScreen;
import frostnox.nightfall.client.model.AnimatedItemModel;
import frostnox.nightfall.client.model.entity.PlayerModelNF;
import frostnox.nightfall.client.render.entity.PlayerRendererNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.RenderUtil;
import frostnox.nightfall.util.animation.AnimationCalculator;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.BoundingSphere;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.util.math.Mat4f;
import frostnox.nightfall.util.math.OBB;
import frostnox.nightfall.util.math.Quat;
import frostnox.nightfall.world.Weather;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumMap;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RenderEventHandler {
    private static float lastLight = -1.0f;
    private static float goalLight;
    private static float lastLightTick;

    @SubscribeEvent
    public static void onRenderTooltipColorEvent(RenderTooltipEvent.Color event) {
        if (Minecraft.m_91087_().f_91080_ == null || Minecraft.m_91087_().f_91080_ instanceof AttributeSelectionScreen) {
            event.setBackground(-266264025);
            event.setBorderStart(1352376487);
            event.setBorderEnd(1350929559);
        } else {
            event.setBackground(-266069234);
            event.setBorderStart(1355065478);
            event.setBorderEnd(1352368224);
        }
    }

    @SubscribeEvent
    public static void onFogColorsEvent(EntityViewRenderEvent.FogColors event) {
        FogType type = event.getCamera().m_167685_();
        if (type == FogType.WATER || type == FogType.NONE) {
            Entity entity = event.getCamera().m_90592_();
            float light = entity.f_19853_.m_45517_(LightLayer.SKY, entity.m_146901_());
            if (lastLight == -1.0f) {
                lastLight = light;
                lastLightTick = entity.f_19797_;
            }
            if (goalLight != light) {
                lastLight = Mth.m_14179_((float)Easing.inOutSine.apply(Math.min(1.0f, ((float)entity.f_19797_ - lastLightTick + ClientEngine.get().getPartialTick()) / 20.0f)), (float)lastLight, (float)goalLight);
                lastLightTick = entity.f_19797_;
                goalLight = light;
            }
            float darkness = Mth.m_14179_((float)Easing.inOutSine.apply(Math.min(1.0f, ((float)entity.f_19797_ - lastLightTick + ClientEngine.get().getPartialTick()) / 20.0f)), (float)lastLight, (float)light) / 15.0f;
            if (type == FogType.WATER || LevelData.isPresent(entity.m_183503_()) && entity.m_20299_((float)((float)event.getPartialTicks())).f_82480_ - 416.0 + 16.0 < 0.0) {
                event.setRed(event.getRed() * darkness);
                event.setGreen(event.getGreen() * darkness);
                event.setBlue(event.getBlue() * darkness);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderFogEvent(EntityViewRenderEvent.RenderFogEvent event) {
        FogType fluidFog = event.getCamera().m_167685_();
        if (fluidFog == FogType.NONE) {
            ILevelData capL;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (LevelData.isPresent((Level)level) && (capL = LevelData.get((Level)level)).getGlobalWeather() == Weather.FOG) {
                float intensity = 1.0f - Math.min(0.95f, capL.getFogIntensity());
                float intensitySqr = intensity * intensity;
                event.setCanceled(true);
                event.setNearPlaneDistance(Math.min(event.getNearPlaneDistance(), 460.8f * intensitySqr));
                event.setFarPlaneDistance(Math.min(event.getFarPlaneDistance(), 512.0f * (1.5f * intensitySqr + 0.8f * intensity)));
            }
        } else if (fluidFog == FogType.WATER) {
            event.setCanceled(true);
            event.setFarPlaneDistance(event.getFarPlaneDistance() * 0.6f);
        }
    }

    @SubscribeEvent
    public static void onRenderBlockOverlayEvent(RenderBlockOverlayEvent event) {
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.BLOCK) {
            Player player = event.getPlayer();
            float size = player.m_6972_((Pose)player.m_20089_()).f_20377_ * 0.8f;
            AABB box = AABB.m_165882_((Vec3)player.m_146892_(), (double)size, (double)1.0E-6, (double)size);
            BlockPos pos = event.getBlockPos();
            if (!event.getBlockState().m_60838_((BlockGetter)player.f_19853_, pos) && !Shapes.m_83157_((VoxelShape)event.getBlockState().m_60812_((BlockGetter)player.f_19853_, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)box), (BooleanOp)BooleanOp.f_82689_)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.DEBUG) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        if (mc.f_91074_ == null || !mc.f_91074_.m_7500_() && !mc.f_91074_.m_5833_() && !ClientEngine.get().isDevVersion()) {
            event.setCanceled(true);
            ClientEngine.get().getLimitedDebugScreen().m_94056_(event.getMatrixStack());
        }
    }

    @SubscribeEvent
    public static void onRenderEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            ClientEngine.get().applyWaterShader(event.getProjectionMatrix(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void onRenderLevelLastEvent(RenderLevelLastEvent event) {
        BlockEntity blockEntity;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null || mc.f_91075_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3i hit = ClientEngine.get().microHitResult;
        BlockPos pos = ClientEngine.get().microBlockEntityPos;
        if (hit != null && pos != null && (blockEntity = level.m_7702_(pos)) instanceof IMicroGrid) {
            IMicroGrid gridEntity = (IMicroGrid)blockEntity;
            mc.f_91063_.m_109111_(event.getProjectionMatrix());
            float rot = -gridEntity.getRotationDegrees();
            Vector3f offset = MathUtil.rotatePointByYaw(gridEntity.getWorldGridOffset(), rot, new Vec2((float)(-gridEntity.getGridXSize()) / 32.0f - gridEntity.getWorldGridOffset().m_122239_(), (float)(-gridEntity.getGridZSize()) / 32.0f - gridEntity.getWorldGridOffset().m_122269_()));
            Vector3f hitPos = MathUtil.rotatePointByYaw(new Vector3f((float)hit.m_123341_() / 16.0f, (float)hit.m_123342_() / 16.0f, (float)hit.m_123343_() / 16.0f), rot);
            double cubeX = (float)pos.m_123341_() + offset.m_122239_() + hitPos.m_122239_();
            double cubeY = (float)pos.m_123342_() + offset.m_122260_() + hitPos.m_122260_();
            double cubeZ = (float)pos.m_123343_() + offset.m_122269_() + hitPos.m_122269_();
            VoxelShape cube = Shapes.m_166049_((double)cubeX, (double)cubeY, (double)cubeZ, (double)(cubeX + 0.0625), (double)(cubeY + 0.0625), (double)(cubeZ + 0.0625));
            poseStack.m_85836_();
            poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
            if (rot != 0.0f) {
                if (rot == -270.0f) {
                    poseStack.m_85837_(-0.0625, 0.0, 0.0);
                } else if (rot == -180.0f) {
                    poseStack.m_85837_(-0.0625, 0.0, -0.0625);
                } else if (rot == -90.0f) {
                    poseStack.m_85837_(0.0, 0.0, -0.0625);
                }
            }
            RenderUtil.drawCubeOutlineWorld(poseStack, buffer, new Color(10, 10, 10, 255), cube);
            poseStack.m_85849_();
        }
        if (!mc.f_91066_.m_92176_().m_90612_() && mc.f_91075_.m_5830_()) {
            mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
    }

    @SubscribeEvent
    public static void onRenderHandEvent(RenderHandEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack stack = event.getPoseStack();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            float f;
            InteractionHand hand = event.getHand();
            if (!player.m_6084_()) {
                return;
            }
            IActionTracker capA = ActionTracker.get((Entity)player);
            IPlayerData capP = PlayerData.get((Player)player);
            Action action = capA.getAction();
            if (player.f_108611_ && (player.m_6117_() || !capA.isInactive())) {
                player.f_108611_ = false;
            }
            if (!capP.getHeldContents().m_128456_()) {
                CompoundTag contents;
                BlockState state;
                BlockEntity blockEntity;
                event.setCanceled(true);
                if (hand == InteractionHand.MAIN_HAND && (blockEntity = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)(state = Block.m_49803_((int)(contents = capP.getHeldContents()).m_128451_("state"))), (CompoundTag)contents)) instanceof IHoldable) {
                    int light;
                    IHoldable holdable = (IHoldable)blockEntity;
                    stack.m_85836_();
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    stack.m_85837_(-0.5, -1.0 - (1.0 - (double)AnimationUtil.getHoldProgress((Player)player, event.getPartialTicks())) + holdable.getFirstPersonYOffset(), 0.5);
                    int n = light = state.m_60788_((BlockGetter)player.f_19853_, player.m_142538_()) ? 0xF000F0 : event.getPackedLight();
                    if (holdable.useBlockEntityItemRenderer()) {
                        BlockEntityRenderer renderer = mc.m_167982_().m_112265_(blockEntity);
                        renderer.m_6922_(blockEntity, event.getPartialTicks(), stack, event.getMultiBufferSource(), light, OverlayTexture.f_118083_);
                    }
                    mc.m_91289_().renderSingleBlock(state, stack, event.getMultiBufferSource(), light, OverlayTexture.f_118083_, blockEntity.getModelData());
                    stack.m_85849_();
                }
                return;
            }
            if (mc.f_91066_.f_92080_ && !capA.isStunned() && hand == InteractionHand.MAIN_HAND) {
                RenderEventHandler.softenBobbingTransformations(stack, (Player)player, 0.15f, event.getPartialTicks());
                if (!capA.isInactive() && action.getTotalStates() > 1 && hand == capP.getActiveHand()) {
                    float progress = 1.0f;
                    float ticks = ClientEngine.get().getPartialTick();
                    AnimationCalculator calc = new AnimationCalculator(capA.getDuration(), capA.getFrame(), ticks, Easing.inOutSine);
                    if (capA.getState() == 0 && ActionsNF.isEmpty(action.chainsFrom().getId())) {
                        calc.setEasing(Easing.inSine);
                        progress = calc.getProgress();
                    } else if (capA.getState() == action.getTotalStates() - 1) {
                        calc.setEasing(Easing.outSine);
                        progress = 1.0f - calc.getProgress();
                    }
                    RenderEventHandler.softenBobbingTransformations(stack, (Player)player, progress * 0.85f, event.getPartialTicks());
                }
            }
            if (mc.f_91066_.f_92080_) {
                float intensity = 1.0f;
                MobEffectInstance starvation = player.m_21124_((MobEffect)EffectsNF.STARVATION_1.get());
                if (starvation == null) {
                    starvation = player.m_21124_((MobEffect)EffectsNF.STARVATION.get());
                }
                if (starvation != null) {
                    intensity = Math.min(6.0f, 1.0f + (float)starvation.m_19557_() / 4800.0f);
                }
                float bob0 = intensity * Mth.m_14179_((float)event.getPartialTicks(), (float)Mth.m_14031_((float)((float)(player.f_19797_ - 1) * 0.03f)), (float)Mth.m_14031_((float)((float)player.f_19797_ * 0.03f)));
                float bob1 = intensity * Mth.m_14179_((float)event.getPartialTicks(), (float)Mth.m_14031_((float)((float)(player.f_19797_ + 19) * 0.025f)), (float)Mth.m_14031_((float)((float)(player.f_19797_ + 20) * 0.025f)));
                if (hand == InteractionHand.MAIN_HAND) {
                    stack.m_85837_((double)(0.01f * bob1), (double)(0.008f * bob0), 0.0);
                } else {
                    float bob2 = intensity * Mth.m_14179_((float)event.getPartialTicks(), (float)Mth.m_14089_((float)((float)(player.f_19797_ - 1) * 0.03f)), (float)Mth.m_14089_((float)((float)player.f_19797_ * 0.03f)));
                    float bob3 = intensity * Mth.m_14179_((float)event.getPartialTicks(), (float)Mth.m_14089_((float)((float)(player.f_19797_ + 19) * 0.025f)), (float)Mth.m_14089_((float)((float)(player.f_19797_ + 20) * 0.025f)));
                    stack.m_85837_((double)(-0.01f * bob1 + 0.01f * bob3), (double)(-0.008f * bob0 + 0.008f * bob2), 0.0);
                }
            }
            float modifiedPartial = capA.modifyPartialTick(ClientEngine.get().getPartialTick());
            ItemInHandRenderer renderer = Minecraft.m_91087_().m_91292_();
            BakedModel bob2 = Minecraft.m_91087_().m_91291_().m_174264_(ClientEngine.get().mainHandItem, player.f_19853_, (LivingEntity)player, 0);
            if (bob2 instanceof AnimatedItemModel.Model) {
                AnimatedItemModel.Model model = (AnimatedItemModel.Model)bob2;
                f = (float)model.swapYOffset;
            } else {
                f = 0.0f;
            }
            float swapYOffsetMain = f;
            float mainSwap = (1.0f - Mth.m_14179_((float)event.getPartialTicks(), (float)ClientEngine.get().oMainHandHeight, (float)ClientEngine.get().mainHandHeight)) * (-0.8f + swapYOffsetMain) + (1.0f - Mth.m_14179_((float)event.getPartialTicks(), (float)renderer.f_109303_, (float)renderer.f_109302_)) * 0.6f;
            mainSwap += -0.14f * Easing.inOutSine.apply(Mth.m_14179_((float)modifiedPartial, (float)ClientEngine.get().lastMainHandLowerTime, (float)ClientEngine.get().mainHandLowerTime) / 4.0f);
            if (hand == InteractionHand.MAIN_HAND) {
                renderer.f_109300_ = !capA.isInactive() && player.m_21205_().m_41619_() ? ItemStack.f_41583_ : ClientEngine.get().mainHandItem;
                stack.m_85837_(0.0, (double)mainSwap, 0.0);
            } else {
                float f2;
                BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(ClientEngine.get().offHandItem, player.f_19853_, (LivingEntity)player, 0);
                if (bakedModel instanceof AnimatedItemModel.Model) {
                    AnimatedItemModel.Model model = (AnimatedItemModel.Model)bakedModel;
                    f2 = (float)model.swapYOffset;
                } else {
                    f2 = 0.0f;
                }
                float swapYOffsetOff = f2;
                float offSwap = (1.0f - Mth.m_14179_((float)event.getPartialTicks(), (float)ClientEngine.get().oOffHandHeight, (float)ClientEngine.get().offHandHeight)) * (-0.8f + swapYOffsetOff) + event.getEquipProgress() * 0.6f;
                renderer.f_109301_ = !capA.isInactive() && player.m_21206_().m_41619_() ? ItemStack.f_41583_ : ClientEngine.get().offHandItem;
                stack.m_85837_(0.0, (double)((offSwap += -0.14f * Easing.inOutSine.apply(Mth.m_14179_((float)modifiedPartial, (float)ClientEngine.get().lastOffHandLowerTime, (float)ClientEngine.get().offHandLowerTime) / 4.0f)) - mainSwap), 0.0);
            }
            if (hand == InteractionHand.MAIN_HAND && capP.getHoldTicks() != -1) {
                stack.m_85837_(0.0, -0.35 * (double)AnimationUtil.getHoldProgress((Player)player, modifiedPartial), 0.0);
            }
            float climbProgress = AnimationUtil.getClimbProgress((Player)player, modifiedPartial);
            if (hand == InteractionHand.MAIN_HAND && climbProgress > 0.0f) {
                climbProgress = AnimationUtil.applyEasing(climbProgress, Easing.outSine);
                if (!capA.isInactive()) {
                    climbProgress = capA.getState() == 0 ? (climbProgress *= 1.0f - capA.getProgress(ClientEngine.get().getPartialTick())) : (capA.getState() == action.getTotalStates() - 1 ? (climbProgress *= capA.getProgress(ClientEngine.get().getPartialTick())) : 0.0f);
                }
                stack.m_85837_(0.0, (double)(-0.14f * climbProgress), 0.0);
            }
            if (hand == InteractionHand.MAIN_HAND && capA.isStunned()) {
                AnimationCalculator stunCalc = new AnimationCalculator(capA.getStunDuration(), capA.getStunFrame(), ClientEngine.get().getPartialTick(), Easing.inOutSine);
                stunCalc.setStaticVector(0.0f, 0.0f, 0.0f);
                stunCalc.length /= 2;
                stunCalc.setEasing(Easing.outQuart);
                float mag = Math.max(0.4f, (float)capA.getStunDuration() / 12.0f);
                stunCalc.add(0.0f, -0.6f * mag, 0.2f * mag);
                if (capA.getStunFrame() > capA.getStunDuration() / 2) {
                    stunCalc.length = capA.getStunDuration();
                    stunCalc.setEasing(Easing.inOutSine);
                    stunCalc.offset = capA.getStunDuration() / 2;
                    stunCalc.extend(0.0f, 0.0f, 0.0f);
                }
                Vector3f vec = stunCalc.getTransformations();
                stack.m_85837_((double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_());
            }
            if (!capA.isInactive() && action instanceof IClientAction) {
                Vector3f vec;
                IClientAction clientAction = (IClientAction)((Object)action);
                int xSide = hand == InteractionHand.MAIN_HAND ? 1 : -1;
                int side = 1;
                float ticks = ClientEngine.get().getPartialTick();
                AnimationCalculator calc = new AnimationCalculator(Math.min(6, capA.getDuration()), capA.getFrame(), capA.modifyPartialTick(ticks), Easing.inOutSine);
                calc.setStaticVector(0.0f, 0.0f, 0.0f);
                boolean emptyHand = player.m_21120_(hand).m_41619_();
                if (emptyHand) {
                    xSide = 0;
                }
                if (capP.getActiveHand() == InteractionHand.OFF_HAND && hand == InteractionHand.OFF_HAND) {
                    xSide = player.m_21205_().m_41619_() ? 0 : -xSide;
                    side = -1;
                }
                if (capP.getActiveHand() != hand || emptyHand || capP.getActiveHand() == InteractionHand.OFF_HAND && hand == InteractionHand.OFF_HAND) {
                    clientAction.transformOppositeHandFP(calc, xSide, side, capA);
                }
                if (capA.isStunned()) {
                    AnimationCalculator stunCalc = new AnimationCalculator(capA.getStunDuration(), capA.getStunFrame(), ticks, Easing.inOutSine);
                    stunCalc.setStaticVector(calc.getTransformations());
                    stunCalc.length /= 2;
                    stunCalc.setEasing(Easing.outQuart);
                    if (capA.getStunFrame() > capA.getStunDuration() / 2) {
                        stunCalc.length = capA.getStunDuration();
                        stunCalc.setEasing(Easing.inOutSine);
                        stunCalc.offset = capA.getStunDuration() / 2;
                        stunCalc.extend(0.0f, 0.0f, 0.0f);
                    }
                    vec = stunCalc.getTransformations();
                } else {
                    vec = calc.getTransformations();
                }
                stack.m_85837_((double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_());
            }
        }
    }

    private static void softenBobbingTransformations(PoseStack matrixStack, Player player, float progress, float partialTicks) {
        float deltaDistanceWalked = player.f_19787_ - player.f_19867_;
        float distanceWalked = -(player.f_19787_ + deltaDistanceWalked * partialTicks);
        float cameraYaw = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-(Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI - 0.2f)) * cameraYaw) * 5.0f) * 0.7f * progress));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 3.0f) * 0.7f * progress));
        matrixStack.m_85837_((double)(-(Mth.m_14031_((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 0.5f) * 0.7f * progress), (double)(-(-Math.abs(Mth.m_14089_((float)(distanceWalked * (float)Math.PI)) * cameraYaw)) * 0.7f * progress), 0.0);
    }

    @SubscribeEvent
    public static void onPlayerRenderEventPre(RenderPlayerEvent.Pre event) {
        IActionTracker capA;
        event.setCanceled(true);
        AbstractClientPlayer player = (AbstractClientPlayer)event.getPlayer();
        PlayerRendererNF renderer = ClientEngine.get().getPlayerCombatRenderer(event.getRenderer());
        PoseStack matrix = event.getPoseStack();
        float partial = event.getPartialTick();
        if (player.m_6084_() && (capA = ActionTracker.get((Entity)player)).getState() == capA.getAction().getChargeState() && !capA.isStunnedOrHitPaused()) {
            capA.setChargePartial(ClientEngine.get().getPartialTick());
        }
        renderer.m_7392_(player, 1.0f, partial, matrix, event.getMultiBufferSource(), event.getPackedLight());
    }

    @SubscribeEvent
    public static void onRenderLivingEventPre(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
    }

    @SubscribeEvent
    public static void onCameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
        Camera camera = event.getCamera();
        Entity entity = camera.m_90592_();
        if (camera.m_90594_() && !entity.m_5833_()) {
            Camera.NearPlane plane = camera.m_167684_();
            Vec3 toEntity = camera.m_90583_().m_82546_(entity.m_146892_());
            if (toEntity.m_82556_() > 0.04) {
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
                for (Vec3 planeVec : Arrays.asList(plane.m_167695_(0.0f, 1.0f), plane.m_167695_(1.0f, 0.0f), plane.m_167695_(-1.0f, 0.0f), plane.m_167694_(), plane.m_167698_(), plane.m_167699_(), plane.m_167700_())) {
                    Vec3 camPos = camera.m_90583_();
                    Vec3 adjustedPos = camPos.m_82549_(planeVec);
                    blockPos.m_122169_(adjustedPos.f_82479_, adjustedPos.f_82480_, adjustedPos.f_82481_);
                    if (!LevelUtil.isPointVisuallyInBlock(entity.f_19853_, (BlockPos)blockPos, adjustedPos)) continue;
                    Vec3 scaledPos = camPos;
                    for (double scale = 0.01; scale < 1.0; scale += 0.01) {
                        double x = toEntity.f_82479_ * scale;
                        double y = toEntity.f_82480_ * scale;
                        double z = toEntity.f_82481_ * scale;
                        if (Mth.m_14107_((double)(adjustedPos.f_82479_ - x)) == blockPos.m_123341_() && Mth.m_14107_((double)(adjustedPos.f_82480_ - y)) == blockPos.m_123342_() && Mth.m_14107_((double)(adjustedPos.f_82481_ - z)) == blockPos.m_123343_()) continue;
                        scaledPos = camPos.m_82546_(toEntity.m_82490_(scale));
                        Vec3 adjustedScaledPos = scaledPos.m_82549_(planeVec);
                        blockPos.m_122169_(adjustedScaledPos.f_82479_, adjustedScaledPos.f_82480_, adjustedScaledPos.f_82481_);
                        if (!LevelUtil.isPointVisuallyInBlock(entity.f_19853_, (BlockPos)blockPos, adjustedScaledPos)) break;
                    }
                    camera.m_90581_(scaledPos);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_6084_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            ClientEngine.get().tickRenderStart();
            EntityLightEngine.get().tickRenderStart();
        } else {
            ClientEngine.get().tickRenderEnd();
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEventPost(RenderLivingEvent.Post<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        ActionableEntity entity;
        if (!Minecraft.m_91087_().m_91290_().m_114377_()) {
            return;
        }
        OBB[] oBBArray = event.getEntity();
        if (oBBArray instanceof Player) {
            Player player = (Player)oBBArray;
            if (!player.m_6084_()) {
                return;
            }
            if (!(event.getRenderer().m_7200_() instanceof PlayerModelNF)) {
                return;
            }
            capA = ActionTracker.get((Entity)player);
            if (capA.isStunnedOrHitPaused() || !capA.isDamaging()) {
                return;
            }
            IPlayerData capP = PlayerData.get(player);
            if (capP.getHitStopFrame() != -1) {
                return;
            }
            Action action = capA.getAction();
            if (!(action instanceof Attack)) {
                return;
            }
            Attack attack = (Attack)action;
            if (!(action instanceof IClientAction)) {
                return;
            }
            IClientAction clientAction = (IClientAction)((Object)action);
            float partialTicks = ClientEngine.get().getPartialTick();
            PoseStack stack = event.getPoseStack();
            stack.m_85836_();
            AnimationData data = attack.getAnimationData((LivingEntity)player, (IActionTracker)capA).get((Object)EntityPart.HAND_RIGHT);
            int frame = capA.getFrame();
            int duration = capA.getDuration();
            int side = PlayerData.get(player).getActiveHand() == InteractionHand.MAIN_HAND ? 1 : -1;
            clientAction.transformModelFP(capA.getState(), frame, duration, action.getChargeProgress(capA.getCharge(), capA.getChargePartial()), (LivingEntity)player, data);
            Mat4f userMatrix = new Mat4f(new Quat(player.m_5686_(partialTicks), Vector3f.f_122222_, true));
            userMatrix.multiply(new Quat(player.m_5675_(partialTicks), Vector3f.f_122225_, true));
            translation = attack.getTranslation((LivingEntity)player);
            BoundingSphere[] spheres = attack.getHurtSpheres((LivingEntity)player).getSpheres();
            Vector3f offset = attack.getOffset((LivingEntity)player);
            for (int i = 0; i < spheres.length; ++i) {
                spheres[i].transformFP(data, userMatrix, translation, offset, side != 1);
                spheres[i].yPos += (double)player.m_20192_();
                RenderEventHandler.renderWireSphere(stack.m_85850_().m_85861_(), event.getMultiBufferSource(), spheres[i]);
            }
            stack.m_85849_();
        } else {
            capA = event.getEntity();
            if (capA instanceof ActionableEntity) {
                Action attack;
                entity = (ActionableEntity)((Object)capA);
                LivingEntity user = event.getEntity();
                IActionTracker capA = entity.getActionTracker();
                if (entity.m_6084_() && capA.isDamaging() && (attack = capA.getAction()) instanceof Attack) {
                    Attack attack2 = (Attack)attack;
                    float partialTicks = ClientEngine.get().getPartialTick();
                    PoseStack stack = event.getPoseStack();
                    Matrix4f matrix = event.getPoseStack().m_85850_().m_85861_();
                    stack.m_85836_();
                    Mat4f userMatrix = new Mat4f(new Quat(entity.getAttackYRot(partialTicks), Vector3f.f_122225_, true));
                    EnumMap<EntityPart, AnimationData> transforms = attack2.getAnimationData(user, capA);
                    AnimationCalculator mCalc = new AnimationCalculator(capA.getDuration(), capA.getFrame(), partialTicks, Easing.inOutSine);
                    attack2.transformModel(capA.getState(), capA.getFrame(), capA.getDuration(), capA.getAction().getChargeProgress(capA.getCharge(), capA.getChargePartial()), attack2.getPitch(user, partialTicks), user, transforms, mCalc);
                    AnimationData layer = new AnimationData();
                    layer.update(capA.getFrame(), capA.getDuration(), partialTicks);
                    attack2.transformLayer(capA.getState(), capA.getFrame(), capA.getDuration(), capA.getAction().getChargeProgress(capA.getCharge(), capA.getChargePartial()), user, layer);
                    BoundingSphere[] spheres = attack2.getHurtSpheres(user).getSpheres();
                    Vector3f offset = attack2.getOffset(user);
                    translation = attack2.getTranslation(user);
                    Vector3f mVec = mCalc.getTransformations();
                    userMatrix.multiply(new Quat(mVec.m_122260_(), Vector3f.f_122225_, true));
                    Mat4f localMatrix = new Mat4f();
                    Vector3f lVec = layer.rCalc.getTransformations();
                    localMatrix.multiply(new Quat(lVec.m_122269_(), Vector3f.f_122227_, true));
                    localMatrix.multiply(new Quat(lVec.m_122260_(), Vector3f.f_122225_, true));
                    localMatrix.multiply(new Quat(lVec.m_122239_(), Vector3f.f_122223_, true));
                    AnimationData[] transformsArray = transforms.values().toArray(new AnimationData[0]);
                    for (int i = 0; i < spheres.length; ++i) {
                        spheres[i].transform(transformsArray, userMatrix, localMatrix, translation, offset);
                        RenderEventHandler.renderWireSphere(matrix, event.getMultiBufferSource(), spheres[i]);
                    }
                    stack.m_85849_();
                }
            }
        }
        entity = event.getEntity();
        if (entity instanceof IOrientedHitBoxes) {
            IOrientedHitBoxes hitBoxesEntity = (IOrientedHitBoxes)((Object)entity);
            PoseStack stack = event.getPoseStack();
            for (OBB box : hitBoxesEntity.getOBBs(ClientEngine.get().getPartialTick())) {
                stack.m_85836_();
                stack.m_85837_(box.translation.f_82479_, box.translation.f_82480_, box.translation.f_82481_);
                stack.m_85845_(box.rotation);
                stack.m_85837_((double)box.center.m_122239_(), (double)box.center.m_122260_(), (double)box.center.m_122269_());
                LevelRenderer.m_109608_((PoseStack)stack, (VertexConsumer)event.getMultiBufferSource().m_6299_(RenderType.m_110504_()), (double)(-box.extents.f_82479_), (double)(-box.extents.f_82480_), (double)(-box.extents.f_82481_), (double)box.extents.f_82479_, (double)box.extents.f_82480_, (double)box.extents.f_82481_, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                stack.m_85849_();
            }
        }
    }

    public static void renderWireSphere(Matrix4f matrix, MultiBufferSource bufferSource, BoundingSphere sphere) {
        double i;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        double inc = sphere.radius * 0.1;
        VertexConsumer builder = bufferSource.m_6299_(RenderType.m_173247_());
        for (i = -Math.PI; i < Math.PI; i += inc) {
            builder.m_85982_(matrix, (float)(sphere.xPos + Math.cos(i) * sphere.radius), (float)(sphere.yPos + Math.sin(i) * sphere.radius), (float)sphere.zPos).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        }
        builder = bufferSource.m_6299_(RenderType.m_173247_());
        for (i = -Math.PI; i < Math.PI; i += inc) {
            builder.m_85982_(matrix, (float)(sphere.xPos + Math.cos(i) * sphere.radius), (float)sphere.yPos, (float)(sphere.zPos + Math.sin(i) * sphere.radius)).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        }
        builder = bufferSource.m_6299_(RenderType.m_173247_());
        for (i = -Math.PI; i < Math.PI; i += inc) {
            builder.m_85982_(matrix, (float)sphere.xPos, (float)(sphere.yPos + Math.cos(i) * sphere.radius), (float)(sphere.zPos + Math.sin(i) * sphere.radius)).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        }
    }
}

