/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item;

import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.PlayerActionSet;
import frostnox.nightfall.item.IArmament;
import frostnox.nightfall.item.ImpactSoundType;
import frostnox.nightfall.world.ToolActionsNF;
import java.util.List;
import net.minecraftforge.common.ToolAction;

public enum Armament implements IArmament
{
    ADZE(PlayerActionSet.ADZE, HurtSphere.ADZE, DamageType.SLASHING, ImpactSoundType.PIERCE, true, ToolActionsNF.STRIP, ToolActionsNF.TILL),
    AXE(PlayerActionSet.AXE, HurtSphere.AXE, DamageType.SLASHING, ImpactSoundType.STRIKE, true, new ToolAction[0]),
    CHISEL(PlayerActionSet.CHISEL, HurtSphere.CHISEL, DamageType.PIERCING, ImpactSoundType.PIERCE, true, ToolActionsNF.REFINE),
    DAGGER(PlayerActionSet.DAGGER, HurtSphere.DAGGER, DamageType.SLASHING, ImpactSoundType.SLASH, true, ToolActionsNF.SKIN),
    HAMMER(PlayerActionSet.HAMMER, HurtSphere.HAMMER, DamageType.STRIKING, ImpactSoundType.STRIKE, true, new ToolAction[0]),
    MACE(PlayerActionSet.MACE, HurtSphere.MACE, DamageType.STRIKING, ImpactSoundType.STRIKE, false, new ToolAction[0]),
    PICKAXE(PlayerActionSet.PICKAXE, HurtSphere.PICKAXE, DamageType.STRIKING, ImpactSoundType.STRIKE, true, new ToolAction[0]),
    SABRE(PlayerActionSet.SABRE, HurtSphere.SABRE, DamageType.SLASHING, ImpactSoundType.SLASH, false, new ToolAction[0]),
    SHOVEL(PlayerActionSet.SHOVEL, HurtSphere.SHOVEL, DamageType.STRIKING, ImpactSoundType.STRIKE, true, new ToolAction[0]),
    SICKLE(PlayerActionSet.SICKLE, HurtSphere.SICKLE, DamageType.SLASHING, ImpactSoundType.SLASH, true, new ToolAction[0]),
    SPEAR(PlayerActionSet.SPEAR, HurtSphere.SPEAR, DamageType.PIERCING, ImpactSoundType.PIERCE, false, new ToolAction[0]),
    SWORD(PlayerActionSet.SWORD, HurtSphere.SWORD, DamageType.SLASHING, ImpactSoundType.SLASH, false, new ToolAction[0]);

    private final PlayerActionSet actionSet;
    private final HurtSphere hurtSphere;
    private final DamageType damageType;
    private final ImpactSoundType impactSoundType;
    private final List<ToolAction> toolActions;
    private final boolean canDig;

    private Armament(PlayerActionSet actionSet, HurtSphere hurtSphere, DamageType damageType, ImpactSoundType impactSoundType, boolean canDig, ToolAction ... toolActions) {
        this.actionSet = actionSet;
        this.hurtSphere = hurtSphere;
        this.damageType = damageType;
        this.impactSoundType = impactSoundType;
        this.canDig = canDig;
        this.toolActions = List.of(toolActions);
    }

    @Override
    public PlayerActionSet getActionSet() {
        return this.actionSet;
    }

    @Override
    public HurtSphere getHurtSpheres() {
        return this.hurtSphere;
    }

    @Override
    public DamageType getDefaultDamageType() {
        return this.damageType;
    }

    @Override
    public ImpactSoundType getImpactSoundType() {
        return this.impactSoundType;
    }

    @Override
    public List<ToolAction> getToolActions() {
        return this.toolActions;
    }

    @Override
    public boolean canDig() {
        return this.canDig;
    }
}

