/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item;

import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.item.ArmorType;
import frostnox.nightfall.item.IStyle;
import frostnox.nightfall.item.Weight;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.registries.ForgeRegistryEntry;

public interface ITieredArmorMaterial {
    public int getDurability(EquipmentSlot var1);

    public float getDefense(EquipmentSlot var1, DamageType[] var2, boolean var3);

    public float getFinalDamage(EquipmentSlot var1, DamageType[] var2, int var3, float var4, boolean var5);

    public int getTier();

    @Nullable
    public ArmorType getArmorType();

    @Nullable
    public IStyle getStyle();

    public Weight getWeight();

    public int getEnchantability();

    public SoundEvent getSoundEvent();

    public String getName();

    public String getStyledArmorName();

    public float getKnockbackResistance(EquipmentSlot var1);

    public int getDefaultColor();

    public boolean isMetal();

    public Poise getPoise();

    public static float getSlotModifier(EquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                return 0.125f;
            }
            case LEGS: {
                return 0.3f;
            }
            case CHEST: {
                return 0.4f;
            }
            case HEAD: {
                return 0.175f;
            }
        }
        return 0.0f;
    }

    public static class Entry
    extends ForgeRegistryEntry<Entry> {
        public final ITieredArmorMaterial value;

        public Entry(ITieredArmorMaterial value) {
            this.value = value;
        }
    }
}

