/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item;

import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.Metal;
import frostnox.nightfall.item.ArmorType;
import frostnox.nightfall.item.IStyle;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.Style;
import frostnox.nightfall.item.Weight;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.CombatUtil;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;

public enum TieredArmorMaterial implements ITieredArmorMaterial
{
    LEATHER(0, null, null, 8, Weight.LIGHT, false, new float[]{0.2f, 0.2f, 0.15f, 0.1f, 0.1f, 0.1f}, 10, (Supplier<SoundEvent>)SoundsNF.LIGHT_ARMOR_EQUIP, 0.1f, 13336911, Poise.NONE),
    PADDED(0, null, null, 8, Weight.LIGHT, false, new float[]{0.25f, 0.2f, 0.1f, 0.05f, 0.1f, 0.1f}, 10, (Supplier<SoundEvent>)SoundsNF.LIGHT_ARMOR_EQUIP, 0.1f, 0xFFDFAF, Poise.NONE),
    RAGGED(0, null, Style.UNDEAD, 8, Weight.LIGHT, false, new float[]{0.15f, 0.1f, 0.1f, 0.0f, 0.05f, 0.05f}, 10, (Supplier<SoundEvent>)SoundsNF.LIGHT_ARMOR_EQUIP, 0.0f, 11846077, Poise.NONE),
    RUSTED(Metal.METEORITE, ArmorType.PLATE, Style.UNDEAD, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.25f, 11846077),
    COPPER_PLATE_SURVIVOR(Metal.COPPER, ArmorType.PLATE, Style.SURVIVOR, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    COPPER_SCALE_SURVIVOR(Metal.COPPER, ArmorType.SCALE, Style.SURVIVOR, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    COPPER_CHAINMAIL_SURVIVOR(Metal.COPPER, ArmorType.CHAINMAIL, Style.SURVIVOR, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    BRONZE_PLATE_SURVIVOR(Metal.BRONZE, ArmorType.PLATE, Style.SURVIVOR, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    BRONZE_SCALE_SURVIVOR(Metal.BRONZE, ArmorType.SCALE, Style.SURVIVOR, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    BRONZE_CHAINMAIL_SURVIVOR(Metal.BRONZE, ArmorType.CHAINMAIL, Style.SURVIVOR, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    IRON_PLATE_SURVIVOR(Metal.IRON, ArmorType.PLATE, Style.SURVIVOR, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    IRON_SCALE_SURVIVOR(Metal.IRON, ArmorType.SCALE, Style.SURVIVOR, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    IRON_CHAINMAIL_SURVIVOR(Metal.IRON, ArmorType.CHAINMAIL, Style.SURVIVOR, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    STEEL_PLATE_SURVIVOR(Metal.STEEL, ArmorType.PLATE, Style.SURVIVOR, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    STEEL_SCALE_SURVIVOR(Metal.STEEL, ArmorType.SCALE, Style.SURVIVOR, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    STEEL_CHAINMAIL_SURVIVOR(Metal.STEEL, ArmorType.CHAINMAIL, Style.SURVIVOR, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    METEORITE_PLATE_SURVIVOR(Metal.METEORITE, ArmorType.PLATE, Style.SURVIVOR, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    METEORITE_SCALE_SURVIVOR(Metal.METEORITE, ArmorType.SCALE, Style.SURVIVOR, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    METEORITE_CHAINMAIL_SURVIVOR(Metal.METEORITE, ArmorType.CHAINMAIL, Style.SURVIVOR, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    COPPER_PLATE_EXPLORER(Metal.COPPER, ArmorType.PLATE, Style.EXPLORER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    COPPER_SCALE_EXPLORER(Metal.COPPER, ArmorType.SCALE, Style.EXPLORER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    COPPER_CHAINMAIL_EXPLORER(Metal.COPPER, ArmorType.CHAINMAIL, Style.EXPLORER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    BRONZE_PLATE_EXPLORER(Metal.BRONZE, ArmorType.PLATE, Style.EXPLORER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    BRONZE_SCALE_EXPLORER(Metal.BRONZE, ArmorType.SCALE, Style.EXPLORER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    BRONZE_CHAINMAIL_EXPLORER(Metal.BRONZE, ArmorType.CHAINMAIL, Style.EXPLORER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    IRON_PLATE_EXPLORER(Metal.IRON, ArmorType.PLATE, Style.EXPLORER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    IRON_SCALE_EXPLORER(Metal.IRON, ArmorType.SCALE, Style.EXPLORER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    IRON_CHAINMAIL_EXPLORER(Metal.IRON, ArmorType.CHAINMAIL, Style.EXPLORER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    STEEL_PLATE_EXPLORER(Metal.STEEL, ArmorType.PLATE, Style.EXPLORER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    STEEL_SCALE_EXPLORER(Metal.STEEL, ArmorType.SCALE, Style.EXPLORER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    STEEL_CHAINMAIL_EXPLORER(Metal.STEEL, ArmorType.CHAINMAIL, Style.EXPLORER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    METEORITE_PLATE_EXPLORER(Metal.METEORITE, ArmorType.PLATE, Style.EXPLORER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    METEORITE_SCALE_EXPLORER(Metal.METEORITE, ArmorType.SCALE, Style.EXPLORER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    METEORITE_CHAINMAIL_EXPLORER(Metal.METEORITE, ArmorType.CHAINMAIL, Style.EXPLORER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    COPPER_PLATE_SLAYER(Metal.COPPER, ArmorType.PLATE, Style.SLAYER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    COPPER_SCALE_SLAYER(Metal.COPPER, ArmorType.SCALE, Style.SLAYER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    COPPER_CHAINMAIL_SLAYER(Metal.COPPER, ArmorType.CHAINMAIL, Style.SLAYER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    BRONZE_PLATE_SLAYER(Metal.BRONZE, ArmorType.PLATE, Style.SLAYER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    BRONZE_SCALE_SLAYER(Metal.BRONZE, ArmorType.SCALE, Style.SLAYER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    BRONZE_CHAINMAIL_SLAYER(Metal.BRONZE, ArmorType.CHAINMAIL, Style.SLAYER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    IRON_PLATE_SLAYER(Metal.IRON, ArmorType.PLATE, Style.SLAYER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    IRON_SCALE_SLAYER(Metal.IRON, ArmorType.SCALE, Style.SLAYER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    IRON_CHAINMAIL_SLAYER(Metal.IRON, ArmorType.CHAINMAIL, Style.SLAYER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    STEEL_PLATE_SLAYER(Metal.STEEL, ArmorType.PLATE, Style.SLAYER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    STEEL_SCALE_SLAYER(Metal.STEEL, ArmorType.SCALE, Style.SLAYER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    STEEL_CHAINMAIL_SLAYER(Metal.STEEL, ArmorType.CHAINMAIL, Style.SLAYER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF),
    METEORITE_PLATE_SLAYER(Metal.METEORITE, ArmorType.PLATE, Style.SLAYER, 11, Weight.HEAVY, (Supplier<SoundEvent>)SoundsNF.PLATE_ARMOR_EQUIP, 0.5f, 0xFFDFAF),
    METEORITE_SCALE_SLAYER(Metal.METEORITE, ArmorType.SCALE, Style.SLAYER, 11, Weight.MEDIUM, (Supplier<SoundEvent>)SoundsNF.SCALE_ARMOR_EQUIP, 0.25f, 13336911),
    METEORITE_CHAINMAIL_SLAYER(Metal.METEORITE, ArmorType.CHAINMAIL, Style.SLAYER, 11, Weight.MEDIUM, () -> SoundEvents.f_11672_, 0.25f, 0xFFDFAF);

    private static final int[] MAX_DAMAGE_ARRAY;
    private final int tier;
    @Nullable
    private final ArmorType armorType;
    @Nullable
    private final IStyle style;
    private final Weight weight;
    private final float[] defense;
    private final String name;
    private final String armorName;
    private final int maxDamageFactor;
    private final int enchantability;
    private final Supplier<SoundEvent> soundEvent;
    private final float knockbackResistance;
    private final int defaultColor;
    private final boolean isMetal;
    private final Poise poise;

    private TieredArmorMaterial(@Nullable int tier, ArmorType armorType, IStyle style, int maxDamageFactor, Weight weight, boolean isMetal, float[] defense, int enchantability, Supplier<SoundEvent> soundEvent, float knockbackResistance, int defaultColor, Poise poise) {
        this.tier = tier;
        this.armorType = armorType;
        this.style = style;
        this.weight = weight;
        this.armorName = this.name = this.toString().toLowerCase(Locale.ROOT);
        this.maxDamageFactor = maxDamageFactor;
        this.defense = defense;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.knockbackResistance = knockbackResistance;
        this.defaultColor = defaultColor;
        this.isMetal = isMetal;
        this.poise = poise;
    }

    private TieredArmorMaterial(IMetal metal, ArmorType armorType, IStyle style, int maxDamageFactor, Weight weight, Supplier<SoundEvent> soundEvent, float knockbackResistance, int defaultColor) {
        this.tier = metal.getTier();
        this.armorType = armorType;
        this.style = style;
        this.weight = weight;
        this.name = this.toString().toLowerCase(Locale.ROOT);
        this.armorName = this.name.replace(metal.getName() + "_", "");
        this.maxDamageFactor = maxDamageFactor;
        this.defense = new float[6];
        for (int i = 0; i < 6; ++i) {
            this.defense[i] = metal.getBaseDefenses().get(i).floatValue() * armorType.defenseMul.get(i).floatValue();
        }
        this.enchantability = 0;
        this.soundEvent = soundEvent;
        this.knockbackResistance = knockbackResistance;
        this.defaultColor = defaultColor;
        this.isMetal = true;
        this.poise = armorType.poise;
    }

    public static ITieredArmorMaterial fromString(String name) {
        for (ITieredArmorMaterial.Entry material : RegistriesNF.getTieredArmorMaterials()) {
            if (!name.contains(material.value.getName())) continue;
            return material.value;
        }
        return null;
    }

    @Override
    public int getDurability(EquipmentSlot slotIn) {
        int durability = MAX_DAMAGE_ARRAY[slotIn.m_20749_()] * this.maxDamageFactor;
        if (this.style == Style.SURVIVOR) {
            durability = Math.round((float)durability * 1.1f);
        }
        return durability;
    }

    @Override
    public float getDefense(EquipmentSlot slot, DamageType[] types, boolean asAverage) {
        float total = 0.0f;
        for (DamageType type : types) {
            if (!type.isDefensible()) continue;
            total += this.defense[type.ordinal()] * (asAverage ? ITieredArmorMaterial.getSlotModifier(slot) : 1.0f);
        }
        return total / (float)types.length;
    }

    @Override
    public float getFinalDamage(EquipmentSlot slot, DamageType[] types, int currentDurability, float damage, boolean asAverage) {
        return CombatUtil.applyArmorDamageReduction(damage, currentDurability, this.getDurability(slot), this.getDefense(slot, types, asAverage));
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    @Nullable
    public ArmorType getArmorType() {
        return this.armorType;
    }

    @Override
    @Nullable
    public IStyle getStyle() {
        return this.style;
    }

    @Override
    public Weight getWeight() {
        return this.weight;
    }

    @Override
    public int getEnchantability() {
        return this.enchantability;
    }

    @Override
    public SoundEvent getSoundEvent() {
        return this.soundEvent.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStyledArmorName() {
        return this.armorName;
    }

    @Override
    public float getKnockbackResistance(EquipmentSlot slot) {
        return this.knockbackResistance * ITieredArmorMaterial.getSlotModifier(slot);
    }

    @Override
    public int getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public boolean isMetal() {
        return this.isMetal;
    }

    @Override
    public Poise getPoise() {
        return this.poise;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

