/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.gui.screen.item.BuildingMaterialItemScreen;
import frostnox.nightfall.data.recipe.BuildingRecipe;
import frostnox.nightfall.item.client.IModifiable;
import frostnox.nightfall.item.client.ISwapBehavior;
import frostnox.nightfall.item.item.ScreenCacheItem;
import frostnox.nightfall.util.LevelUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class BuildingMaterialItem
extends ScreenCacheItem
implements IModifiable,
ISwapBehavior {
    public BuildingMaterialItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public List<BuildingRecipe> getRecipes(Level level, @Nullable Player player) {
        return level.m_7465_().m_44013_(BuildingRecipe.TYPE).stream().filter(buildingRecipe -> buildingRecipe.baseItem == this && buildingRecipe.isUnlocked(player)).sorted((r1, r2) -> {
            if (r1.menuOrder < 0 && r2.menuOrder >= 0) {
                return 1;
            }
            if (r2.menuOrder < 0 && r1.menuOrder >= 0) {
                return -1;
            }
            if (r1.menuOrder == r2.menuOrder || r1.menuOrder < 0) {
                return -r1.output.m_5524_().compareTo(r2.output.m_5524_());
            }
            return r1.menuOrder > r2.menuOrder ? 1 : -1;
        }).collect(Collectors.toList());
    }

    protected boolean canUseSelectedItem(int index, Level level, Player player, InteractionHand hand) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        List<BuildingRecipe> recipes = this.getRecipes(level, player);
        if (index < 0 || index >= recipes.size()) {
            return false;
        }
        ItemStack item = player.m_21120_(hand);
        BuildingRecipe recipe = recipes.get(index);
        ItemStack extraItem = BuildingMaterialItem.getExtraItem(item, player, hand, recipe.extraIngredient, recipe.extraAmount);
        return item.m_41613_() >= recipe.baseAmount && extraItem.m_41613_() >= recipe.extraAmount;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.f_46443_) {
            Player player;
            if (isSelected) {
                Player player2;
                if (entityIn instanceof Player && PlayerData.isPresent(player2 = (Player)entityIn)) {
                    ClientEngine.get().canUseModifiableMain = this.canUseSelectedItem(ClientEngine.get().getModifiableIndexMain(), worldIn, player2, InteractionHand.MAIN_HAND);
                }
            } else if (itemSlot == 0 && entityIn instanceof Player && PlayerData.isPresent(player = (Player)entityIn)) {
                ClientEngine.get().canUseModifiableOff = this.canUseSelectedItem(ClientEngine.get().getModifiableIndexOff(), worldIn, player, InteractionHand.OFF_HAND);
            }
        }
    }

    @Override
    public Optional<Screen> modifyStartClient(Minecraft mc, ItemStack item, Player player, InteractionHand hand) {
        if (mc.f_91080_ == null) {
            List<BuildingRecipe> recipes = this.getRecipes(player.f_19853_, player);
            if (recipes.isEmpty()) {
                return Optional.empty();
            }
            ObjectArrayList items = new ObjectArrayList(recipes.size());
            for (int i = 0; i < recipes.size(); ++i) {
                items.add(i, recipes.get(i).m_8043_());
            }
            return Optional.of(new BuildingMaterialItemScreen(PlayerData.get(player).isMainhandActive(), this, recipes, (List<ItemStack>)items));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Screen> modifyContinueClient(Minecraft mc, ItemStack item, Player player, InteractionHand hand, int heldTime) {
        return Optional.empty();
    }

    @Override
    public void modifyReleaseClient(Minecraft mc, ItemStack item, Player player, InteractionHand hand, int heldTime) {
        if (mc.f_91080_ instanceof BuildingMaterialItemScreen) {
            mc.f_91080_.m_7379_();
        }
    }

    @Override
    public int getBackgroundUOffset() {
        return 22;
    }

    @Override
    public void swapClient(Minecraft mc, ItemStack item, Player player, boolean mainHand) {
        BuildingMaterialItemScreen.initSelection(mc, this, mainHand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        List<BuildingRecipe> recipes = this.getRecipes(level, player);
        int index = LevelUtil.getModifiableItemIndex(level, player, hand);
        if (index < 0 || index >= recipes.size()) {
            return InteractionResultHolder.m_19098_((Object)item);
        }
        BuildingRecipe recipe = recipes.get(index);
        ItemStack extraItem = BuildingMaterialItem.getExtraItem(item, player, hand, recipe.extraIngredient, recipe.extraAmount);
        if (!(player.m_150110_().f_35937_ || item.m_41613_() >= recipe.baseAmount && extraItem.m_41613_() >= recipe.extraAmount)) {
            return InteractionResultHolder.m_19098_((Object)item);
        }
        ItemStack placeItem = recipe.m_8043_();
        InteractionResultHolder result = placeItem.m_41682_(level, player, hand);
        if (!result.m_19089_().m_19077_() && this.m_41472_()) {
            if (player.m_36391_(((ItemStack)result.m_19095_()).getFoodProperties((LivingEntity)player).m_38747_())) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)((ItemStack)result.m_19095_()));
            }
            return InteractionResultHolder.m_19100_((Object)((ItemStack)result.m_19095_()));
        }
        if (result.m_19089_().m_19077_() && !player.m_150110_().f_35937_) {
            item.m_41774_(recipe.baseAmount);
            extraItem.m_41774_(recipe.extraAmount);
        }
        return result;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_6084_()) {
            return InteractionResult.FAIL;
        }
        List<BuildingRecipe> recipes = this.getRecipes(context.m_43725_(), player);
        int index = LevelUtil.getModifiableItemIndex(context.m_43725_(), player, context.m_43724_());
        if (index < 0 || index >= recipes.size()) {
            return InteractionResult.FAIL;
        }
        BuildingRecipe recipe = recipes.get(index);
        ItemStack item = context.m_43722_();
        ItemStack extraItem = BuildingMaterialItem.getExtraItem(item, player, context.m_43724_(), recipe.extraIngredient, recipe.extraAmount);
        if (!(player.m_150110_().f_35937_ || item.m_41613_() >= recipe.baseAmount && extraItem.m_41613_() >= recipe.extraAmount)) {
            return InteractionResult.FAIL;
        }
        ItemStack placeItem = recipe.m_8043_();
        InteractionResult result = placeItem.m_41661_(new UseOnContext(context.m_43725_(), player, context.m_43724_(), placeItem, context.m_43718_()));
        if (!result.m_19077_() && this.m_41472_()) {
            InteractionResult eatResult = this.m_7203_(context.m_43725_(), player, context.m_43724_()).m_19089_();
            return eatResult == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : eatResult;
        }
        if (result.m_19077_() && !player.m_150110_().f_35937_) {
            item.m_41774_(recipe.baseAmount);
            extraItem.m_41774_(recipe.extraAmount);
        }
        return result;
    }

    private static ItemStack getExtraItem(ItemStack heldItem, Player player, InteractionHand hand, Ingredient target, int amount) {
        ItemStack offItem;
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        if (hand == InteractionHand.MAIN_HAND && target.test(offItem = player.m_21206_()) && offItem.m_41613_() >= amount) {
            return offItem;
        }
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (item == heldItem || !target.test(item) || item.m_41613_() < amount) continue;
            return item;
        }
        return ItemStack.f_41583_;
    }
}

