/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.item.item.ItemNF;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FilledBucketItem
extends ItemNF {
    public final boolean placeSources;
    private final Supplier<? extends FlowingFluid> heldFluid;

    public FilledBucketItem(boolean placeSources, Supplier<? extends FlowingFluid> heldFluid, Item.Properties builder) {
        super(builder);
        this.placeSources = placeSources;
        this.heldFluid = heldFluid;
    }

    public Fluid getFluid() {
        return (Fluid)this.heldFluid.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack filledBucket = player.m_21120_(hand);
        BlockHitResult blockResult = FilledBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)filledBucket);
        }
        if (blockResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)filledBucket);
        }
        BlockPos pos = blockResult.m_82425_();
        Direction direction = blockResult.m_82434_();
        BlockPos blockPos = pos.m_142300_(direction);
        if (level.m_7966_(player, pos) && player.m_36204_(blockPos, direction, filledBucket)) {
            LiquidBlockContainer liquidBlock;
            BlockPos targetPos;
            BlockState blockState = level.m_8055_(pos);
            Block block = blockState.m_60734_();
            BlockPos blockPos2 = targetPos = block instanceof LiquidBlockContainer && (liquidBlock = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockState, (Fluid)this.heldFluid.get()) ? pos : blockPos;
            if (this.emptyFluid(player, level, targetPos, blockResult)) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, targetPos, filledBucket);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)(!player.m_150110_().f_35937_ ? filledBucket.getContainerItem() : filledBucket), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)filledBucket);
        }
        return InteractionResultHolder.m_19100_((Object)filledBucket);
    }

    protected boolean emptyFluid(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result) {
        LiquidBlockContainer liquidBlock;
        boolean canPlace;
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        Material material = blockState.m_60767_();
        boolean replaceable = blockState.m_60722_((Fluid)this.heldFluid.get());
        boolean bl = canPlace = replaceable || blockState.m_60795_() || block instanceof LiquidBlockContainer && (liquidBlock = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockState, (Fluid)this.heldFluid.get());
        if (!canPlace) {
            return result != null && this.emptyFluid(player, level, result.m_82425_().m_142300_(result.m_82434_()), null);
        }
        if (level.m_6042_().m_63951_() && this.heldFluid.get().m_205067_(FluidTags.f_13131_)) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer) {
            liquidBlock = (LiquidBlockContainer)block;
            if (this.placeSources) {
                if (liquidBlock.m_6044_((BlockGetter)level, pos, blockState, (Fluid)this.heldFluid.get())) {
                    liquidBlock.m_7361_((LevelAccessor)level, pos, blockState, this.heldFluid.get().m_76068_(false));
                    this.playEmptySound(player, (LevelAccessor)level, pos);
                    return true;
                }
            } else if (liquidBlock.m_6044_((BlockGetter)level, pos, blockState, this.heldFluid.get().m_5615_())) {
                liquidBlock.m_7361_((LevelAccessor)level, pos, blockState, this.heldFluid.get().m_5615_().m_76145_());
                this.playEmptySound(player, (LevelAccessor)level, pos);
                return true;
            }
        }
        if (!level.f_46443_ && replaceable && !material.m_76332_()) {
            level.m_46961_(pos, true);
        }
        BlockState newState = this.heldFluid.get().m_76145_().m_76188_();
        if (this.placeSources) {
            if (!level.m_7731_(pos, newState, 11) && !blockState.m_60819_().m_76170_()) {
                return false;
            }
        } else {
            FluidState fluidState = blockState.m_60819_();
            int amount = this.heldFluid.get().m_7430_(this.heldFluid.get().m_5615_().m_76145_());
            if ((this.heldFluid.get() == fluidState.m_76152_() || this.heldFluid.get().m_5615_() == fluidState.m_76152_()) && amount <= fluidState.m_76186_()) {
                return false;
            }
            if (!level.m_7731_(pos, (BlockState)newState.m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(amount)), 11)) {
                return false;
            }
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }

    public void playEmptySound(@Nullable Player pPlayer, LevelAccessor level, BlockPos pos) {
        SoundEvent soundevent = this.heldFluid.get().getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = SoundEvents.f_11778_;
        }
        level.m_5594_(pPlayer, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_((Entity)pPlayer, GameEvent.f_157769_, pos);
    }
}

