/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.block.IIgnitable;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.FireBlockNF;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.item.item.ItemNF;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class FireStarterItem
extends ItemNF {
    public final Map<TagKey<Item>, Integer> pairedItems;
    public final Supplier<SoundEvent> sound;
    public final float breakChance;

    public FireStarterItem(Map<TagKey<Item>, Integer> pairedItems, Supplier<SoundEvent> sound, float breakChance, Item.Properties properties) {
        super(properties);
        this.pairedItems = pairedItems;
        this.sound = sound;
        this.breakChance = breakChance;
    }

    protected int getIgnitionBound(ItemStack otherStack) {
        for (TagKey<Item> tag : this.pairedItems.keySet()) {
            if (!otherStack.m_204117_(tag)) continue;
            return this.pairedItems.get(tag);
        }
        return -1;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack heldStack = context.m_43722_();
        ItemStack otherStack = player.m_21120_(context.m_43724_() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        int randBound = this.getIgnitionBound(otherStack);
        if (randBound >= 0) {
            IIgnitable burnable;
            BlockPos pos;
            Level level = context.m_43725_();
            BlockState state = level.m_8055_(pos = context.m_8083_());
            Block block = state.m_60734_();
            if (block instanceof IIgnitable && !(burnable = (IIgnitable)block).isIgnited(state)) {
                if (!level.m_5776_() && (randBound < 1 || level.m_5822_().nextInt(randBound) == 0) && burnable.tryToIgnite(level, pos, state, heldStack, TieredHeat.RED)) {
                    level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
                }
                if (level.f_46441_.nextFloat() < this.breakChance) {
                    LevelUtil.breakItem(heldStack, player, context.m_43724_());
                }
                level.m_5594_(player, pos, this.sound.get(), SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            BlockPos adjPos = pos.m_142300_(context.m_43719_());
            if (FireBlockNF.canBePlacedAt(level, adjPos)) {
                if (!(level.m_5776_() || randBound >= 1 && level.m_5822_().nextInt(randBound) != 0)) {
                    level.m_7731_(adjPos, ((FireBlockNF)BlocksNF.FIRE.get()).m_5573_(new BlockPlaceContext(context)), 11);
                    level.m_142346_((Entity)player, GameEvent.f_157797_, adjPos);
                    PlayerData.get(player).addKnowledge(KnowledgeNF.STARTED_FIRE.getId());
                }
                if (level.f_46441_.nextFloat() < this.breakChance) {
                    LevelUtil.breakItem(heldStack, player, context.m_43724_());
                }
                level.m_5594_(player, pos, this.sound.get(), SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

