/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.model.entity.AttachedEntityModel;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.item.IItemLightSource;
import frostnox.nightfall.item.client.IAnimatedEquipment;
import frostnox.nightfall.item.item.BlockItemNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class LanternItem
extends BlockItemNF
implements IItemLightSource,
IAnimatedEquipment {
    public final Supplier<? extends Item> extinguishedItem;

    public LanternItem(Block block, Supplier<? extends Item> extinguishedItem, Item.Properties properties) {
        super(block, properties);
        this.extinguishedItem = extinguishedItem;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_20069_()) {
            LevelUtil.extinguishItemEntity(entity, this.extinguishedItem.get(), false);
        }
        return false;
    }

    @Override
    public int getBrightness() {
        return 14;
    }

    @Override
    public double getLightRadiusSqr() {
        return 196.0;
    }

    @Override
    public Item getExtinguishedItem() {
        return this.extinguishedItem.get();
    }

    @Override
    public double getEquippedHeight(Pose pose) {
        if (pose == Pose.STANDING) {
            return 0.55f;
        }
        if (pose == Pose.CROUCHING) {
            return 0.4f;
        }
        return 0.1f;
    }

    @Override
    public void animate(AttachedEntityModel model, ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        model.child.f_104205_ = -0.2618f - Math.abs(Mth.m_14089_((float)(limbSwing * 0.3331f + 0.5235988f)) * limbSwingAmount * 0.3f);
        ItemStack leggings = entity.m_6844_(EquipmentSlot.LEGS);
        model.child.f_104200_ = !leggings.m_41619_() && !leggings.m_204117_(TagsNF.WAIST_OFFSET_NONE) ? (leggings.m_204117_(TagsNF.WAIST_OFFSET_EXTRA) ? 5.5f : 5.0f) : 4.5f;
    }
}

