/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.item.IItemLightSource;
import frostnox.nightfall.item.item.ItemNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.function.Supplier;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LightItem
extends ItemNF
implements IItemLightSource {
    private final Supplier<? extends Item> extinguishedItem;
    private final double equippedHeight;
    private final double radiusSqr;
    private final int brightness;

    public LightItem(double equippedHeight, int brightness, double radius, Supplier<? extends Item> extinguishedItem, Item.Properties properties) {
        super(properties);
        this.extinguishedItem = extinguishedItem;
        this.equippedHeight = equippedHeight;
        this.radiusSqr = radius * radius;
        this.brightness = brightness;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_20069_() && this.extinguishedItem.get() != this) {
            LevelUtil.extinguishItemEntity(entity, this.extinguishedItem.get(), true);
        }
        return false;
    }

    @Override
    public Item getExtinguishedItem() {
        return this.extinguishedItem.get();
    }

    @Override
    public double getEquippedHeight(Pose pose) {
        return this.equippedHeight;
    }

    @Override
    public int getBrightness() {
        return this.brightness;
    }

    @Override
    public double getLightRadiusSqr() {
        return this.radiusSqr;
    }
}

