/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.PlayerActionSet;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.HeldToolRecipe;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.item.ITieredItemMaterial;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.item.Weight;
import frostnox.nightfall.item.item.ItemNF;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.world.ToolActionsNF;
import it.unimi.dsi.fastutil.floats.FloatImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;

public class MeleeWeaponItem
extends ItemNF
implements IWeaponItem {
    public final PlayerActionSet actionSet;
    public final ITieredItemMaterial material;
    public final boolean canDig;
    private final HurtSphere spheres;
    private final HurtSphere npcSpheres;
    private final DamageType[] defaultType;
    private final List<ToolAction> toolActions;
    private final List<Float> defense;

    public MeleeWeaponItem(ITieredItemMaterial material, PlayerActionSet actionSet, HurtSphere spheres, HurtSphere npcSpheres, boolean canDig, float durabilityMultiplier, Item.Properties builder, List<ToolAction> toolActions, DamageType ... defaultType) {
        super(builder.m_41499_(Math.round((float)material.m_6609_() * durabilityMultiplier)));
        this.actionSet = actionSet;
        this.material = material;
        this.spheres = spheres;
        this.npcSpheres = npcSpheres;
        this.toolActions = toolActions;
        this.defaultType = defaultType;
        this.canDig = canDig;
        IMetal metal = material.getMetal();
        if (metal != null) {
            List<Float> baseDefenses = metal.getBaseDefenses();
            float[] temp = new float[6];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = baseDefenses.get(i).floatValue() * actionSet.defenseMul;
            }
            this.defense = FloatImmutableList.of((float[])temp);
        } else {
            this.defense = FloatImmutableList.of((float[])new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        }
    }

    public MeleeWeaponItem(ITieredItemMaterial material, PlayerActionSet actionSet, HurtSphere spheres, HurtSphere npcSpheres, boolean canDig, Item.Properties builder, List<ToolAction> toolActions, DamageType ... defaultType) {
        this(material, actionSet, spheres, npcSpheres, canDig, 1.0f, builder, toolActions, defaultType);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        boolean doExpandPrompt;
        if (this.canDig) {
            float speed = this.material.m_6624_();
            if (((Action)((Object)this.actionSet.basic.get())).is(TagsNF.ADZE_ACTION)) {
                speed *= 0.75f;
            }
            if (((Action)((Object)this.actionSet.basic.get())).is(TagsNF.SLOW_PLAYER_HARVEST_ACTION)) {
                speed *= 0.5f;
            }
            tooltips.add((Component)new TranslatableComponent("item.dig_speed", new Object[]{(int)speed}).m_130940_(ChatFormatting.DARK_GREEN));
        }
        int size = tooltips.size();
        List<Component> basic = ((Action)((Object)this.actionSet.basic.get())).getTooltips(pStack, pLevel, pIsAdvanced);
        for (int i = 0; i < basic.size(); ++i) {
            TranslatableComponent text = new TranslatableComponent("action.basic");
            if (ClientEngine.get().isShiftHeld()) {
                text.m_7220_((Component)new TranslatableComponent("action.control", new Object[]{ClientEngine.get().getAttackKeyName()}).m_130940_(ChatFormatting.AQUA));
            }
            text.m_130946_(": ");
            if (i == 0) {
                tooltips.add((Component)text.m_7220_(basic.get(i)));
                continue;
            }
            tooltips.add(basic.get(i));
        }
        List<Component> alternate = ((Action)((Object)this.actionSet.alternate.get())).getTooltips(pStack, pLevel, pIsAdvanced);
        for (int i = 0; i < alternate.size(); ++i) {
            TranslatableComponent text = new TranslatableComponent("action.alternate");
            if (ClientEngine.get().isShiftHeld()) {
                text.m_7220_((Component)new TranslatableComponent("action.control_held", new Object[]{ClientEngine.get().getAttackKeyName()}).m_130940_(ChatFormatting.AQUA));
            }
            text.m_130946_(": ");
            if (i == 0) {
                tooltips.add((Component)text.m_7220_(alternate.get(i)));
                continue;
            }
            tooltips.add(alternate.get(i));
        }
        List<Component> technique = ((Action)((Object)this.actionSet.defaultTech.get())).getTooltips(pStack, pLevel, pIsAdvanced);
        for (int i = 0; i < technique.size(); ++i) {
            TranslatableComponent text = new TranslatableComponent("action.technique");
            if (ClientEngine.get().isShiftHeld()) {
                text.m_7220_((Component)new TranslatableComponent("action.control", new Object[]{ClientEngine.get().getUseKeyName()}).m_130940_(ChatFormatting.AQUA));
            }
            text.m_130946_(": ");
            if (i == 0) {
                tooltips.add((Component)text.m_7220_(technique.get(i)));
                continue;
            }
            tooltips.add(technique.get(i));
        }
        boolean bl = doExpandPrompt = tooltips.size() != size;
        if (!this.toolActions.isEmpty()) {
            TranslatableComponent toolActionsText = new TranslatableComponent("item.toolactions");
            for (int i = 0; i < this.toolActions.size(); ++i) {
                toolActionsText.m_7220_((Component)new TranslatableComponent("toolaction." + this.toolActions.get(i).name()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)));
                if (i == this.toolActions.size() - 1) continue;
                toolActionsText.m_130946_(", ");
            }
            tooltips.add((Component)toolActionsText);
        }
        this.appendExtraHoverText(pStack, pLevel, tooltips, pIsAdvanced);
        if (!ClientEngine.get().isShiftHeld() && doExpandPrompt) {
            tooltips.add((Component)new TranslatableComponent("tooltip.expand_prompt").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
        }
    }

    protected void appendExtraHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
    }

    @Override
    public boolean hasAction(ResourceLocation id, Player player) {
        return this.getActionSet(player).containsAction(id);
    }

    @Override
    public float getDamageMultiplier() {
        return this.material.getDamageMultiplier();
    }

    public float m_8102_(ItemStack stack, BlockState block) {
        return this.material.m_6624_();
    }

    @Override
    public Weight getWeight() {
        return this.material.getWeight();
    }

    @Override
    public HurtSphere getHurtSpheres() {
        return this.spheres;
    }

    @Override
    public HurtSphere getNPCHurtSpheres() {
        return this.npcSpheres;
    }

    @Override
    public DamageType[] getDefaultDamageTypes() {
        return this.defaultType;
    }

    @Override
    @Nullable
    public AttackEffect getBaseAttackEffect() {
        return this.getBaseActionSet().defaultEffect;
    }

    @Override
    public PlayerActionSet getBaseActionSet() {
        return this.actionSet;
    }

    @Override
    public PlayerActionSet getActionSet(Player player) {
        return this.getBaseActionSet();
    }

    @Override
    public float getBaseDamage() {
        return this.getBaseActionSet().attack * this.material.getDamageMultiplier();
    }

    @Override
    public boolean tryBasicAttack(Player user) {
        if (!MeleeWeaponItem.canExecuteAttack(user, false)) {
            return false;
        }
        IActionTracker capA = ActionTracker.get((Entity)user);
        Action action = capA.getAction();
        PlayerActionSet set = this.getActionSet(user);
        if (!ActionsNF.get(set.basic.getId()).canStart((LivingEntity)user) || !action.isEmpty() && !action.isActionEqualOrLinked(set.basic.getId())) {
            return false;
        }
        if (!((Action)((Object)action.getChain((LivingEntity)user).get())).isEmpty()) {
            if (capA.getState() == action.getChainState() || capA.getState() == action.getChainState() - 1 && capA.getFrame() >= capA.getDuration() - 3) {
                capA.queue();
                return true;
            }
        } else if (capA.isInactive()) {
            capA.startAction(set.basic.getId());
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAlternateAttack(Player user) {
        if (!MeleeWeaponItem.canExecuteAttack(user, false)) {
            return false;
        }
        IActionTracker capA = ActionTracker.get((Entity)user);
        Action action = capA.getAction();
        PlayerActionSet set = this.getActionSet(user);
        if (!ActionsNF.get(set.alternate.getId()).canStart((LivingEntity)user) || !action.isEmpty() && !action.isActionEqualOrLinked(set.alternate.getId())) {
            return false;
        }
        if (!((Action)((Object)action.getChain((LivingEntity)user).get())).isEmpty()) {
            if (capA.getState() == action.getChainState() || capA.getState() == action.getChainState() - 1 && capA.getFrame() >= capA.getDuration() - 3) {
                capA.queue();
                return true;
            }
        } else {
            if (capA.getState() == action.getChargeState()) {
                capA.queue();
                return true;
            }
            if (capA.isInactive()) {
                capA.startAction(set.alternate.getId());
                return true;
            }
        }
        return false;
    }

    private boolean canDoRecipe(Player user, Action action, PlayerActionSet set) {
        if (set.recipeAction == null) {
            return false;
        }
        return ActionsNF.get(set.recipeAction.getId()).canStart((LivingEntity)user) && (action.isEmpty() || action.isActionEqualOrLinked(set.recipeAction.getId()));
    }

    private boolean canDoTechnique(Player user, Action action, PlayerActionSet set) {
        return ActionsNF.get(set.defaultTech.getId()).canStart((LivingEntity)user) && (action.isEmpty() || action.isActionEqualOrLinked(set.defaultTech.getId()));
    }

    @Override
    public boolean tryTechnique(Player user) {
        if (!MeleeWeaponItem.canExecuteAttack(user, false)) {
            return false;
        }
        IActionTracker capA = ActionTracker.get((Entity)user);
        Action action = capA.getAction();
        PlayerActionSet set = this.getActionSet(user);
        if (capA.getState() == action.getChargeState()) {
            if (this.canDoTechnique(user, action, set) || this.canDoRecipe(user, action, set)) {
                capA.queue();
                return true;
            }
        } else if (!((Action)((Object)action.getChain((LivingEntity)user).get())).isEmpty()) {
            if (capA.getState() == action.getChainState() && (this.canDoTechnique(user, action, set) || this.canDoRecipe(user, action, set))) {
                capA.queue();
                return true;
            }
        } else if (capA.isInactive()) {
            Optional<HeldToolRecipe> recipe;
            if (this.canDoRecipe(user, action, set) && (recipe = HeldToolRecipe.getRecipe(user)).isPresent()) {
                capA.startAction(set.recipeAction.getId());
                return true;
            }
            if (this.canDoTechnique(user, action, set)) {
                capA.startAction(set.defaultTech.getId());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean tryCrawlingAttack(Player user) {
        if (!MeleeWeaponItem.canExecuteAttack(user, true)) {
            return false;
        }
        IActionTracker capA = ActionTracker.get((Entity)user);
        Action action = capA.getAction();
        PlayerActionSet set = this.getActionSet(user);
        if (!action.canStart((LivingEntity)user) || !action.isEmpty() && !action.isActionEqualOrLinked(set.crawl.getId())) {
            return false;
        }
        if (!((Action)((Object)action.getChain((LivingEntity)user).get())).isEmpty()) {
            if (capA.getState() == action.getChainState() || capA.getState() == action.getChainState() - 1 && capA.getFrame() >= capA.getDuration() - 3) {
                capA.queue();
                return true;
            }
        } else if (capA.isInactive()) {
            capA.startAction(set.crawl.getId());
            return true;
        }
        return false;
    }

    public static boolean canExecuteAttack(Player user, boolean crawling) {
        block3: {
            block2: {
                if (user.m_6117_() || user.m_5833_() || (!crawling ? user.m_20089_() != Pose.STANDING && user.m_20089_() != Pose.CROUCHING : user.m_20089_() != Pose.SWIMMING && user.m_20089_() != Pose.FALL_FLYING)) break block2;
                if (!user.f_20911_) break block3;
            }
            return false;
        }
        IActionTracker capA = ActionTracker.get((Entity)user);
        IPlayerData capP = PlayerData.get(user);
        return !capA.isStunned();
    }

    public void initNBT(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            stack.m_41751_(nbt);
        }
        if (!nbt.m_128441_("UUID")) {
            nbt.m_128359_("UUID", UUID.randomUUID().toString());
            stack.m_41751_(nbt);
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof Player) || !entityIn.m_6084_()) {
            return;
        }
        this.initNBT(stack);
    }

    public boolean onEntitySwing(ItemStack itemStack, LivingEntity entityLivingBase) {
        return !(entityLivingBase instanceof Player) || !entityLivingBase.m_6084_();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (newStack.m_41720_() instanceof MeleeWeaponItem) {
            return !oldStack.m_41783_().m_128461_("UUID").equals(newStack.m_41783_().m_128461_("UUID"));
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return true;
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return this.canDig;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = level.m_8055_(pos);
        BlockState modifiedState = null;
        for (ToolAction action : this.toolActions) {
            modifiedState = state.getToolModifiedState(context, action, false);
            if (modifiedState == null) continue;
            if (action == ToolActionsNF.REFINE) {
                if (!level.f_46443_ && player != null && modifiedState.m_204336_(TagsNF.ANVILS)) {
                    PlayerData.get(player).addKnowledge(KnowledgeNF.IMPROVISED_ANVIL.getId());
                }
                if (state.m_204336_(Tags.Blocks.STONE)) {
                    level.m_5594_(player, pos, (SoundEvent)SoundsNF.CARVE_STONE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    break;
                }
                level.m_5594_(player, pos, (SoundEvent)SoundsNF.CARVE_WOOD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            if (action == ToolActionsNF.STRIP) {
                level.m_5594_(player, pos, (SoundEvent)SoundsNF.STRIP_WOOD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            if (action != ToolActionsNF.TILL) break;
            level.m_5594_(player, pos, (SoundEvent)SoundsNF.TILL_SOIL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            break;
        }
        if (modifiedState != null) {
            level.m_7731_(pos, modifiedState, 11);
            if (player != null) {
                context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity instanceof ActionableEntity) {
            ActionableEntity actionable = (ActionableEntity)entity;
            for (ToolAction toolAction : this.toolActions) {
                boolean interacted = actionable.tryToolAction(stack, player, hand, toolAction);
                if (!interacted) continue;
                if (toolAction == ToolActionsNF.SKIN) {
                    Vec3 pos = entity.m_20182_();
                    player.f_19853_.m_6263_(player, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)SoundsNF.SKIN_FLESH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return this.toolActions.contains(toolAction);
    }

    @Override
    public float getDefense(DamageTypeSource source) {
        float total = 0.0f;
        for (DamageType type : source.types) {
            if (!type.isDefensible()) continue;
            total += this.defense.get(type.ordinal()).floatValue();
        }
        return total / (float)source.types.length;
    }
}

