/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import com.google.common.collect.ImmutableMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.model.entity.AttachedEntityModel;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.item.client.IAnimatedEquipment;
import frostnox.nightfall.item.item.AttributeAccessoryItem;
import frostnox.nightfall.util.AnimationUtil;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class NecklaceItem
extends AttributeAccessoryItem
implements IAnimatedEquipment {
    public NecklaceItem(ImmutableMultimap<Supplier<Attribute>, AttributeModifier> modifiers, Item.Properties properties) {
        super(modifiers, properties);
    }

    @Override
    public void animate(AttachedEntityModel model, ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack chest;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float crouch = AnimationUtil.getCrouchProgress(player, partialTick);
            if (crouch > 0.0f) {
                model.child.f_104203_ = crouch * (float)(-Math.PI) / 8.0f;
                model.child.f_104201_ = -12.5f + crouch;
            } else {
                model.child.f_104202_ = -0.5f * player.m_20998_(partialTick);
                model.child.f_104201_ = -12.5f;
                model.child.f_104203_ = 0.0f;
            }
        }
        float scale = (chest = entity.m_6844_(EquipmentSlot.CHEST)).m_41619_() || chest.m_204117_(TagsNF.NECK_OFFSET_NONE) ? 1.0f : (chest.m_204117_(TagsNF.NECK_OFFSET_EXTRA) ? 1.7f : 1.375f);
        poseStack.m_85841_(1.0f, 1.0f, scale);
    }
}

