/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.HurtSphere;
import frostnox.nightfall.action.player.PlayerActionSet;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.item.ITieredItemMaterial;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.item.item.MeleeWeaponItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;

public class PairedMeleeWeaponItem
extends MeleeWeaponItem {
    public final PlayerActionSet matchingSet;
    public final PlayerActionSet pairedSet;

    public PairedMeleeWeaponItem(ITieredItemMaterial material, PlayerActionSet actionSet, PlayerActionSet matchingSet, PlayerActionSet pairedSet, HurtSphere spheres, HurtSphere npcSpheres, boolean canDig, float durabilityMultiplier, Item.Properties builder, List<ToolAction> toolActions, DamageType ... defaultType) {
        super(material, actionSet, spheres, npcSpheres, canDig, durabilityMultiplier, builder, toolActions, defaultType);
        this.matchingSet = matchingSet;
        this.pairedSet = pairedSet;
    }

    public PairedMeleeWeaponItem(ITieredItemMaterial material, PlayerActionSet actionSet, PlayerActionSet matchingSet, PlayerActionSet pairedSet, HurtSphere spheres, HurtSphere npcSpheres, boolean canDig, Item.Properties builder, List<ToolAction> toolActions, DamageType ... defaultType) {
        this(material, actionSet, matchingSet, pairedSet, spheres, npcSpheres, canDig, 1.0f, builder, toolActions, defaultType);
    }

    @Override
    public PlayerActionSet getActionSet(Player player) {
        IWeaponItem weapon;
        InteractionHand hand = PlayerData.get(player).getOppositeActiveHand();
        Item item = player.m_21120_(hand).m_41720_();
        if (item instanceof IWeaponItem && (weapon = (IWeaponItem)item).getBaseActionSet().equals(this.matchingSet)) {
            return this.pairedSet;
        }
        return this.getBaseActionSet();
    }

    @Override
    protected void appendExtraHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        tooltips.add((Component)new TranslatableComponent("item.pair").m_7220_((Component)new TranslatableComponent("action_set." + this.matchingSet.toString()).m_130940_(ChatFormatting.BLUE)));
        List<Component> basic = ((Action)((Object)this.pairedSet.basic.get())).getTooltips(pStack, pLevel, pIsAdvanced);
        for (int i = 0; i < basic.size(); ++i) {
            TranslatableComponent text = new TranslatableComponent("action.basic_paired");
            if (ClientEngine.get().isShiftHeld()) {
                text.m_7220_((Component)new TranslatableComponent("action.control", new Object[]{ClientEngine.get().getAttackKeyName()}).m_130940_(ChatFormatting.AQUA));
            }
            text.m_130946_(": ");
            if (i == 0) {
                tooltips.add((Component)text.m_7220_(basic.get(i)));
                continue;
            }
            tooltips.add(basic.get(i));
        }
        List<Component> alternate = ((Action)((Object)this.pairedSet.alternate.get())).getTooltips(pStack, pLevel, pIsAdvanced);
        for (int i = 0; i < alternate.size(); ++i) {
            TranslatableComponent text = new TranslatableComponent("action.alternate_paired");
            if (ClientEngine.get().isShiftHeld()) {
                text.m_7220_((Component)new TranslatableComponent("action.control_held", new Object[]{ClientEngine.get().getAttackKeyName()}).m_130940_(ChatFormatting.AQUA));
            }
            text.m_130946_(": ");
            if (i == 0) {
                tooltips.add((Component)text.m_7220_(alternate.get(i)));
                continue;
            }
            tooltips.add(alternate.get(i));
        }
    }
}

