/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.item.IProjectileItem;
import frostnox.nightfall.item.item.ItemNF;
import frostnox.nightfall.util.RenderUtil;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ProjectileItem
extends ItemNF
implements IProjectileItem {
    private final float damage;
    private final float velocityScale;
    private final float inaccuracy;
    private final DamageType[] damageType;
    private final int ammoId;

    public ProjectileItem(float damage, float velocityScale, float inaccuracy, DamageType[] damageType, int ammoId, Item.Properties properties) {
        super(properties);
        this.damage = damage;
        this.velocityScale = velocityScale;
        this.inaccuracy = inaccuracy;
        this.damageType = damageType;
        this.ammoId = ammoId;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        DecimalFormat format = new DecimalFormat("0.0");
        TextComponent text = new TextComponent(format.format(this.damage) + " ");
        text.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN));
        for (int i = 0; i < this.damageType.length; ++i) {
            text.m_7220_((Component)RenderUtil.getDamageTypeText(this.damageType[i]));
            if (i == this.damageType.length - 1) continue;
            text.m_130946_("/");
        }
        pTooltipComponents.add((Component)text);
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public DamageType[] getProjectileDamageType() {
        return this.damageType;
    }

    @Override
    public float getProjectileDamage() {
        return this.damage;
    }

    @Override
    public float getProjectileVelocityScalar() {
        return this.velocityScale;
    }

    @Override
    public float getProjectileInaccuracy() {
        return this.inaccuracy;
    }

    @Override
    public int getAmmoId() {
        return this.ammoId;
    }
}

