/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.gui.screen.item.ModifiableItemScreen;
import frostnox.nightfall.client.gui.screen.item.SimpleModifiableItemScreen;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.item.client.IHeldClientTick;
import frostnox.nightfall.item.client.IModifiable;
import frostnox.nightfall.item.client.ISwapBehavior;
import frostnox.nightfall.item.item.ScreenCacheItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.ActionToServer;
import frostnox.nightfall.util.LevelUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public abstract class ProjectileLauncherItem
extends ScreenCacheItem
implements IActionableItem,
IModifiable,
ISwapBehavior,
IHeldClientTick {
    public final RegistryObject<? extends Action> useAction;
    public final TagKey<Item> ammoTag;

    public ProjectileLauncherItem(RegistryObject<? extends Action> useAction, TagKey<Item> ammoTag, Item.Properties properties) {
        super(properties);
        this.useAction = useAction;
        this.ammoTag = ammoTag;
    }

    public abstract Entity createProjectile(ItemStack var1, Player var2, InteractionHand var3, float var4, ItemStack var5);

    protected abstract Item getDefaultItem();

    protected int getAmmoId(ItemStack ammoItem) {
        return 0;
    }

    @Nullable
    public Entity launchProjectile(ItemStack item, Player user, InteractionHand hand, float velocity) {
        int index = LevelUtil.getModifiableItemIndex(user.f_19853_, user, hand);
        List<ItemStack> ammo = this.getAmmo(user);
        if (ammo.isEmpty() && user.m_150110_().f_35937_) {
            index = 0;
            ammo.add(new ItemStack((ItemLike)this.getDefaultItem()));
        }
        if (index < 0 || index >= ammo.size()) {
            return null;
        }
        item.m_41622_(1, (LivingEntity)user, p -> p.m_21190_(hand));
        if (item.m_41782_()) {
            item.m_41783_().m_128473_("ammo");
        }
        return this.createProjectile(item, user, hand, velocity, user.m_150110_().f_35937_ ? ammo.get(index) : ammo.get(index).m_41620_(1));
    }

    public List<ItemStack> getAmmo(Player player) {
        ObjectArrayList ammo = new ObjectArrayList();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack item = player.m_150109_().m_8020_(i);
            if (!item.m_204117_(this.ammoTag)) continue;
            ammo.add(item);
        }
        return ammo;
    }

    public static int getAmmoByte(ItemStack item) {
        return item.m_41782_() ? (int)item.m_41783_().m_128445_("ammo") : 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player pPlayer, InteractionHand pHand) {
        ItemStack item = pPlayer.m_21120_(pHand);
        if (!((Action)((Object)this.useAction.get())).canStart((LivingEntity)pPlayer)) {
            return InteractionResultHolder.m_19100_((Object)item);
        }
        List<ItemStack> ammo = this.getAmmo(pPlayer);
        if (!ammo.isEmpty() || pPlayer.m_150110_().f_35937_) {
            if (level.m_5776_()) {
                IPlayerData capP = PlayerData.get(pPlayer);
                if (capP.getActiveHand() == pHand) {
                    ActionTracker.get((Entity)pPlayer).startAction(this.useAction.getId());
                    NetworkHandler.toServer(new ActionToServer(capP.isMainhandActive(), this.useAction.getId()));
                }
            } else if (!ammo.isEmpty()) {
                int index = LevelUtil.getModifiableItemIndex(level, pPlayer, pHand);
                if (index < 0 || index >= ammo.size()) {
                    return InteractionResultHolder.m_19100_((Object)item);
                }
                int id = this.getAmmoId(ammo.get(index));
                if (id != 0) {
                    CompoundTag tag = item.m_41784_();
                    tag.m_128344_("ammo", (byte)id);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)item);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.m_150930_(oldStack.m_41720_());
    }

    @Override
    public boolean hasAction(ResourceLocation id, Player player) {
        if (this.useAction.getId().equals((Object)id)) {
            return true;
        }
        for (ResourceLocation linkedId : ((Action)((Object)this.useAction.get())).linkedActions) {
            if (!linkedId.equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Screen> modifyStartClient(Minecraft mc, ItemStack item, Player player, InteractionHand hand) {
        List<ItemStack> ammo;
        IActionTracker capA;
        if (mc.f_91080_ == null && ((capA = ActionTracker.get((Entity)player)).isInactive() || capA.getAction() == this.useAction.get() && capA.getState() > ((Action)((Object)this.useAction.get())).getChargeState() + 1) && !(ammo = this.getAmmo(player)).isEmpty()) {
            return Optional.of(new SimpleModifiableItemScreen(PlayerData.get(player).isMainhandActive(), this, ammo));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Screen> modifyContinueClient(Minecraft mc, ItemStack item, Player player, InteractionHand hand, int heldTime) {
        return this.modifyStartClient(mc, item, player, hand);
    }

    @Override
    public void modifyReleaseClient(Minecraft mc, ItemStack item, Player player, InteractionHand hand, int heldTime) {
        if (mc.f_91080_ instanceof SimpleModifiableItemScreen) {
            mc.f_91080_.m_7379_();
        }
    }

    @Override
    public void swapClient(Minecraft mc, ItemStack item, Player player, boolean mainHand) {
        ModifiableItemScreen.initSelection(mc, this.getAmmo(player), this, mainHand);
    }

    @Override
    public void onHeldTickClient(Minecraft mc, ItemStack item, Player player, boolean mainHand) {
        if (PlayerData.get(player).isMainhandActive() == mainHand) {
            this.swapClient(mc, item, player, mainHand);
        }
    }
}

