/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.item.IGuardingItem;
import frostnox.nightfall.item.item.ActionableItem;
import it.unimi.dsi.fastutil.floats.FloatImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class ShieldItemNF
extends ActionableItem
implements IGuardingItem {
    public final List<Float> defense;

    public ShieldItemNF(float[] defense, RegistryObject<? extends Action> useAction, Item.Properties properties) {
        super(useAction, properties);
        this.defense = FloatImmutableList.of((float[])defense);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !newStack.m_150930_(oldStack.m_41720_());
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, tooltips, pIsAdvanced);
        if (!ClientEngine.get().isShiftHeld()) {
            tooltips.add((Component)new TranslatableComponent("tooltip.expand_prompt").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
        }
    }

    @Override
    public float getDefense(DamageTypeSource source) {
        float total = 0.0f;
        for (DamageType type : source.types) {
            if (!type.isDefensible()) continue;
            total += this.defense.get(type.ordinal()).floatValue();
        }
        return total / (float)source.types.length;
    }
}

