/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import com.google.common.collect.ImmutableMultimap;
import frostnox.nightfall.item.ITieredArmorMaterial;
import frostnox.nightfall.item.Style;
import frostnox.nightfall.item.item.AttributeEquipmentItem;
import frostnox.nightfall.registry.forge.AttributesNF;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TieredArmorItem
extends AttributeEquipmentItem {
    public final ITieredArmorMaterial material;
    protected static final UUID[] MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("d52b28b7-ce27-4dd0-9bc4-f46fa14b97ca"), UUID.fromString("d3f35679-86da-4550-9ac1-36ea29c63640"), UUID.fromString("8ce067ec-def9-4aa8-b6ee-eb9e96c78e1a"), UUID.fromString("4afd627c-c640-4a62-8f55-112ee1442b9f")};

    public TieredArmorItem(ITieredArmorMaterial material, EquipmentSlot slot, Item.Properties builder) {
        super(slot, TieredArmorItem.buildModifiersMap(slot, material), builder.m_41499_(material.getDurability(slot)));
        this.material = material;
    }

    protected static ImmutableMultimap<Supplier<Attribute>, AttributeModifier> buildModifiersMap(EquipmentSlot slot, ITieredArmorMaterial material) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = MODIFIER_UUID_PER_SLOT[slot.m_20749_()];
        if (material.getStyle() == Style.EXPLORER) {
            builder.put(AttributesNF.STAMINA_REDUCTION, (Object)new AttributeModifier(uuid, "stamina_reduction", -0.075, AttributeModifier.Operation.ADDITION));
        } else if (material.getStyle() == Style.SLAYER) {
            builder.put(AttributesNF.BLEEDING_RESISTANCE, (Object)new AttributeModifier(uuid, "bleeding_resistance", 0.125, AttributeModifier.Operation.ADDITION));
            builder.put(AttributesNF.POISON_RESISTANCE, (Object)new AttributeModifier(uuid, "poison_resistance", 0.125, AttributeModifier.Operation.ADDITION));
        }
        if (material.getKnockbackResistance(slot) != 0.0f) {
            builder.put(() -> Attributes.f_22278_, (Object)new AttributeModifier(uuid, "knockback_resistance", (double)material.getKnockbackResistance(slot), AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        float halfDurability;
        float durability;
        if (this.material.getStyle() == Style.SURVIVOR) {
            tooltips.add((Component)new TranslatableComponent("item.armor.style." + this.material.getStyle().getName()).m_130940_(ChatFormatting.GOLD));
        }
        if ((durability = (float)(pStack.m_41776_() - pStack.m_41773_())) < (halfDurability = (float)pStack.m_41776_() / 2.0f)) {
            float durabilityPenalty = 0.5f - durability / halfDurability * 0.5f;
            DecimalFormat format = new DecimalFormat("0.0");
            tooltips.add((Component)new TranslatableComponent("item.durability_penalty", new Object[]{format.format(durabilityPenalty * 100.0f)}).m_130940_(ChatFormatting.DARK_RED));
        }
    }
}

