/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.item.item;

import frostnox.nightfall.block.IIgnitable;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.item.IItemLightSource;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class TorchItem
extends StandingAndWallBlockItem
implements IItemLightSource {
    public final Supplier<? extends Item> extinguishedItem;

    public TorchItem(Block pStandingBlock, Block pWallBlock, Supplier<? extends Item> extinguishedItem, Item.Properties pProperties) {
        super(pStandingBlock, pWallBlock, pProperties);
        this.extinguishedItem = extinguishedItem;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null && !player.m_6047_()) {
            IIgnitable burnable;
            BlockPos pos;
            ItemStack heldStack = context.m_43722_();
            Level level = context.m_43725_();
            BlockState state = level.m_8055_(pos = context.m_8083_());
            Block block = state.m_60734_();
            if (block instanceof IIgnitable && !(burnable = (IIgnitable)block).isIgnited(state)) {
                if (!level.m_5776_() && burnable.tryToIgnite(level, pos, state, heldStack, TieredHeat.RED)) {
                    level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
                }
                level.m_5594_(player, pos, (SoundEvent)SoundsNF.FIRE_WHOOSH.get(), SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.2f + 0.9f);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6225_(context);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_20069_()) {
            LevelUtil.extinguishItemEntity(entity, this.extinguishedItem.get(), true);
        }
        return false;
    }

    @Override
    public int getBrightness() {
        return 15;
    }

    @Override
    public double getLightRadiusSqr() {
        return 225.0;
    }

    @Override
    public Item getExtinguishedItem() {
        return this.extinguishedItem.get();
    }

    @Override
    public double getEquippedHeight(Pose pose) {
        return 1.15f;
    }
}

