/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.util.MathUtil;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    private static final double SCALE = 0.75;
    @Shadow
    private float f_90557_;
    @Shadow
    private float f_90558_;
    @Shadow
    private boolean f_90549_;
    @Shadow
    private BlockGetter f_90550_;
    @Shadow
    private Vec3 f_90552_;
    @Shadow
    private Entity f_90551_;

    @Shadow
    public abstract Camera.NearPlane m_167684_();

    @Shadow
    protected abstract void m_90581_(Vec3 var1);

    @Shadow
    protected abstract void m_90572_(float var1, float var2);

    @Inject(method={"setup"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;move(DDD)V")})
    private void nightfall$applyViewBob(CallbackInfo callbackInfo) {
        Entity entity;
        if (Minecraft.m_91087_().f_91066_.f_92080_ && (entity = this.f_90551_) instanceof Player) {
            Player player = (Player)entity;
            float f = player.f_19787_ - player.f_19867_;
            float partialTick = ClientEngine.get().getPartialTick();
            float f1 = -(player.f_19787_ + f * partialTick);
            float f2 = Mth.m_14179_((float)partialTick, (float)player.f_36099_, (float)player.f_36100_);
            float xBob = Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f;
            float yaw = MathUtil.toRadians(Mth.m_14177_((float)(this.f_90558_ + 90.0f)));
            this.m_90581_(this.f_90552_.m_82520_((double)(xBob * Mth.m_14031_((float)(-yaw))) * 0.75, (double)Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2) * 0.75, (double)(xBob * Mth.m_14089_((float)(-yaw))) * 0.75));
            this.m_90572_(this.f_90558_, this.f_90557_ + Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f * 0.75f);
        }
    }

    @ModifyVariable(method={"getNearPlane"}, at=@At(value="STORE"), ordinal=1)
    private double nightfall$getFov(double fov) {
        Minecraft mc = Minecraft.m_91087_();
        return Math.tan(mc.f_91066_.f_92068_ * (double)Mth.m_14179_((float)ClientEngine.get().getPartialTick(), (float)mc.f_91063_.f_109067_, (float)mc.f_91063_.f_109066_) * (Math.PI / 180) / 2.0) * 0.05;
    }

    @Overwrite
    public FogType m_167685_() {
        if (this.f_90549_) {
            Camera.NearPlane plane = this.m_167684_();
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (Vec3 planeVec : Arrays.asList(plane.f_167687_, plane.m_167694_(), plane.m_167698_(), plane.m_167699_(), plane.m_167700_(), plane.m_167695_(1.0f, 0.0f), plane.m_167695_(-1.0f, 0.0f))) {
                Vec3 adjustedPos = this.f_90552_.m_82549_(planeVec);
                blockPos.m_122169_(adjustedPos.f_82479_, adjustedPos.f_82480_, adjustedPos.f_82481_);
                FluidState fluidState = this.f_90550_.m_6425_((BlockPos)blockPos);
                if (fluidState.m_205070_(FluidTags.f_13131_)) {
                    if (!(adjustedPos.f_82480_ <= (double)(this.getFluidHeight((float)adjustedPos.f_82479_, (float)adjustedPos.f_82481_, (BlockPos)blockPos, fluidState) + (float)blockPos.m_123342_()))) continue;
                    return FogType.WATER;
                }
                if (fluidState.m_205070_(FluidTags.f_13132_)) {
                    if (!(adjustedPos.f_82480_ <= (double)(this.getFluidHeight((float)adjustedPos.f_82479_, (float)adjustedPos.f_82481_, (BlockPos)blockPos, fluidState) + (float)blockPos.m_123342_()))) continue;
                    return FogType.LAVA;
                }
                BlockState blockstate = this.f_90550_.m_8055_((BlockPos)blockPos);
                if (!blockstate.m_60713_(Blocks.f_152499_)) continue;
                return FogType.POWDER_SNOW;
            }
        }
        return FogType.NONE;
    }

    private float getFluidHeight(float x, float z, BlockPos centerPos, FluidState centerFluid) {
        Fluid type = centerFluid.m_76152_();
        float centerHeight = this.getHeight(type, centerPos);
        if (centerHeight >= 1.0f) {
            return centerHeight;
        }
        if ((x %= 1.0f) < 0.0f) {
            x += 1.0f;
        }
        if ((z %= 1.0f) < 0.0f) {
            z += 1.0f;
        }
        float northHeight = this.getHeight(type, centerPos.m_142127_());
        float southHeight = this.getHeight(type, centerPos.m_142128_());
        float eastHeight = this.getHeight(type, centerPos.m_142126_());
        float westHeight = this.getHeight(type, centerPos.m_142125_());
        float avgNW = this.calculateAverageHeight(type, centerHeight, northHeight, westHeight, centerPos.m_142300_(Direction.NORTH).m_142300_(Direction.WEST));
        float avgSE = this.calculateAverageHeight(type, centerHeight, southHeight, eastHeight, centerPos.m_142300_(Direction.SOUTH).m_142300_(Direction.EAST));
        if (x <= z) {
            float avgSW = this.calculateAverageHeight(type, centerHeight, southHeight, westHeight, centerPos.m_142300_(Direction.SOUTH).m_142300_(Direction.WEST));
            return avgNW - -(avgSW - avgNW) * z + (avgSE - avgNW - (avgSW - avgNW)) * x;
        }
        float avgNE = this.calculateAverageHeight(type, centerHeight, northHeight, eastHeight, centerPos.m_142300_(Direction.NORTH).m_142300_(Direction.EAST));
        return avgNW + (avgSE - avgNW - (avgNE - avgNW)) * z - -(avgNE - avgNW) * x;
    }

    private float getHeight(Fluid type, BlockPos pos) {
        BlockState state = this.f_90550_.m_8055_(pos);
        return this.getHeight(type, pos, state, state.m_60819_());
    }

    private float getHeight(Fluid type, BlockPos pos, BlockState state, FluidState fluidState) {
        if (type.m_6212_(fluidState.m_76152_())) {
            BlockState aboveState = this.f_90550_.m_8055_(pos.m_7494_());
            return type.m_6212_(aboveState.m_60819_().m_76152_()) ? 1.0f : fluidState.m_76182_();
        }
        return !state.m_60767_().m_76333_() ? 0.0f : -1.0f;
    }

    private float calculateAverageHeight(Fluid type, float centerHeight, float height1, float height2, BlockPos pos) {
        if (!(height2 >= 1.0f) && !(height1 >= 1.0f)) {
            float[] vec = new float[2];
            if (height2 > 0.0f || height1 > 0.0f) {
                float f = this.getHeight(type, pos);
                if (f >= 1.0f) {
                    return 1.0f;
                }
                CameraMixin.addWeightedHeight(vec, f);
            }
            CameraMixin.addWeightedHeight(vec, centerHeight);
            CameraMixin.addWeightedHeight(vec, height2);
            CameraMixin.addWeightedHeight(vec, height1);
            return vec[0] / vec[1];
        }
        return 1.0f;
    }

    private static void addWeightedHeight(float[] vec, float height) {
        if (height >= 0.8f) {
            vec[0] = vec[0] + height * 10.0f;
            vec[1] = vec[1] + 10.0f;
        } else if (height >= 0.0f) {
            vec[0] = vec[0] + height;
            vec[1] = vec[1] + 1.0f;
        }
    }
}

