/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import frostnox.nightfall.registry.forge.ContainersNF;
import frostnox.nightfall.world.inventory.CapacitySlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChestMenu.class})
public abstract class ChestMenuMixin
extends AbstractContainerMenu {
    protected ChestMenuMixin(@Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;I)V"}, at={@At(value="TAIL")})
    private void nightfall$alterInventorySlots(MenuType<?> pType, int pContainerId, Inventory pPlayerInventory, Container pContainer, int pRows, CallbackInfo callbackInfo) {
        int i;
        int yOff = (pRows - 4) * 18;
        int chestSize = pRows * 9;
        for (i = 0; i < chestSize; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            Slot newSlot = new Slot(pContainer, i, slot.f_40220_, slot.f_40221_ - 10);
            newSlot.f_40219_ = slot.f_40219_;
            this.f_38839_.set(i, (Object)newSlot);
        }
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                int position = c + r * 9;
                int index = chestSize + position;
                Slot slot = c >= 5 ? new CapacitySlot(r * 4 + c - 5, pPlayerInventory, position + 9, 8 + c * 18, 84 + r * 18 + yOff) : new Slot((Container)pPlayerInventory, position + 9, 8 + c * 18, 84 + r * 18 + yOff);
                slot.f_40219_ = index;
                this.f_38839_.set(index, (Object)slot);
            }
        }
        for (i = 0; i < 9; ++i) {
            Slot newSlot = new Slot((Container)pPlayerInventory, i, 8 + i * 18, 142 + yOff);
            newSlot.f_40219_ = chestSize + 27 + i;
            this.f_38839_.set(newSlot.f_40219_, (Object)newSlot);
        }
    }

    @Overwrite
    public static ChestMenu m_39237_(int pContainerId, Inventory pPlayerInventory, Container pContainer) {
        return new ChestMenu((MenuType)ContainersNF.CHEST_9x3.get(), pContainerId, pPlayerInventory, pContainer, 3);
    }

    @Overwrite
    public static ChestMenu m_39246_(int pContainerId, Inventory pPlayerInventory, Container pContainer) {
        return new ChestMenu((MenuType)ContainersNF.CHEST_9x6.get(), pContainerId, pPlayerInventory, pContainer, 6);
    }
}

