/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
extends CapabilityProvider<Entity>
implements Nameable,
EntityAccess,
CommandSource,
IForgeEntity {
    @Shadow
    public Level f_19853_;
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private BlockPos f_19826_;
    @Shadow
    private ChunkPos f_185933_;
    @Shadow
    @Nullable
    private BlockState f_185934_;
    @Shadow
    private EntityInLevelCallback f_146801_;

    @Shadow
    @Nullable
    public abstract GameEventListenerRegistrar m_146887_();

    @Shadow
    public abstract boolean m_146910_();

    private EntityMixin(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Redirect(method={"updateInWaterStateAndDoWaterCurrentPushing"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;resetFallDistance()V"))
    public void nightfall$cancelInWaterFallReset(Entity entity) {
        entity.f_19789_ *= 0.85f;
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;resetFallDistance()V"))
    public void nightfall$cancelDiveWaterFallReset(Entity entity) {
    }

    @Overwrite
    protected BlockPos m_20099_() {
        if (this.f_19825_.f_82480_ % 1.0 == 0.0) {
            return this.m_142538_().m_7495_();
        }
        return this.m_142538_();
    }

    @Inject(method={"getOnPos"}, at={@At(value="TAIL")}, cancellable=true)
    public void nightfall$getOnPos(CallbackInfoReturnable<BlockPos> callbackInfo) {
        int i = Mth.m_14107_((double)this.f_19825_.f_82479_);
        int j = Mth.m_14107_((double)(this.f_19825_.f_82480_ - (double)0.2f));
        int k = Mth.m_14107_((double)this.f_19825_.f_82481_);
        BlockPos pos = new BlockPos(i, j, k);
        if (((BlockPos)callbackInfo.getReturnValue()).equals((Object)pos)) {
            if (this.f_19825_.f_82480_ % 1.0 == 0.0) {
                callbackInfo.setReturnValue((Object)this.m_142538_().m_7495_());
            } else {
                callbackInfo.setReturnValue((Object)this.m_142538_());
            }
        }
    }

    private boolean isNotOnBlock(BlockState state, BlockPos pos, CollisionContext context) {
        if (state.m_60795_()) {
            return true;
        }
        VoxelShape shape = state.m_60742_((BlockGetter)this.f_19853_, pos, context);
        return shape.m_83281_() || shape.m_83215_().f_82292_ + (double)pos.m_123342_() != this.f_19825_.f_82480_;
    }

    @Inject(method={"setPosRaw"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityInLevelCallback;onMove()V")})
    private void nightfall$adjustStandingBlockPosition(CallbackInfo callbackInfo) {
        if (this instanceof Player) {
            CollisionContext collisionContext;
            int zCenter;
            int yOn;
            double x = this.f_19825_.f_82479_;
            double y = this.f_19825_.f_82480_;
            double z = this.f_19825_.f_82481_;
            boolean onEvenHeight = y % 1.0 == 0.0;
            int xCenter = Mth.m_14107_((double)x);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(xCenter, yOn = onEvenHeight ? Mth.m_14107_((double)y) - 1 : Mth.m_14107_((double)y), zCenter = Mth.m_14107_((double)z));
            BlockState state = this.f_19853_.m_8055_((BlockPos)pos);
            if (this.isNotOnBlock(state, (BlockPos)pos, collisionContext = CollisionContext.m_82750_((Entity)((Entity)this)))) {
                AABB bb = this.m_142469_();
                double xWidth = bb.m_82362_() / 2.0;
                double zWidth = bb.m_82385_() / 2.0;
                int xMin = Mth.m_14107_((double)(x - xWidth));
                int xMax = Mth.m_14107_((double)(x + xWidth));
                int zMin = Mth.m_14107_((double)(z - zWidth));
                int zMax = Mth.m_14107_((double)(z + zWidth));
                ObjectOpenHashSet blocks = new ObjectOpenHashSet(4);
                blocks.add(new BlockPos(xMin, yOn, zMin));
                if (zMax != zMin) {
                    blocks.add(new BlockPos(xMin, yOn, zMax));
                }
                if (xMax != xMin) {
                    blocks.add(new BlockPos(xMax, yOn, zMin));
                }
                if (blocks.size() == 3) {
                    blocks.add(new BlockPos(xMax, yOn, zMax));
                }
                double minDistSqr = Double.MAX_VALUE;
                for (BlockPos blockPos : blocks) {
                    double zDist;
                    double xDist;
                    double distSqr;
                    BlockState blockState = this.f_19853_.m_8055_(blockPos);
                    if (this.isNotOnBlock(blockState, blockPos, collisionContext) || !((distSqr = (xDist = (double)blockPos.m_123341_() - x) * xDist + (zDist = (double)blockPos.m_123343_() - z) * zDist) < minDistSqr)) continue;
                    minDistSqr = distSqr;
                    pos.m_122190_((Vec3i)blockPos);
                }
            }
            if (onEvenHeight) {
                pos.m_122173_(Direction.UP);
            }
            if (!pos.equals((Object)this.f_19826_)) {
                this.f_19826_ = pos.m_7949_();
                this.f_185934_ = null;
                if (SectionPos.m_123171_((int)pos.m_123341_()) != this.f_185933_.f_45578_ || SectionPos.m_123171_((int)pos.m_123343_()) != this.f_185933_.f_45579_) {
                    this.f_185933_ = new ChunkPos(this.f_19826_);
                }
            }
        }
    }
}

