/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import frostnox.nightfall.capability.LightData;
import frostnox.nightfall.client.EntityLightEngine;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin<T extends Entity> {
    @Inject(method={"getBlockLightLevel"}, at={@At(value="TAIL")}, cancellable=true)
    private void nightfall$addEntityLightToEntity(T entity, BlockPos pos, CallbackInfoReturnable<Integer> callbackInfo) {
        int selfLight;
        int blockLight = (Integer)callbackInfo.getReturnValue();
        double entityLight = EntityLightEngine.get().getLight(pos);
        if (entity.getCapability(LightData.CAPABILITY).isPresent() && (double)(selfLight = LightData.get(entity).getBrightness()) > entityLight) {
            entityLight = selfLight;
        }
        if (entityLight > (double)blockLight) {
            callbackInfo.setReturnValue((Object)((int)entityLight));
        }
    }
}

