/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.util.math.OBB;
import frostnox.nightfall.world.OrientedEntityHitResult;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin
implements ResourceManagerReloadListener,
AutoCloseable {
    @Inject(method={"resize"}, at={@At(value="HEAD")})
    private void nightfall$resizeShaders(int width, int height, CallbackInfo callbackInfo) {
        if (ClientEngine.get() != null) {
            ClientEngine.get().resize(width, height);
        }
    }

    @Redirect(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;bobView(Lcom/mojang/blaze3d/vertex/PoseStack;F)V"))
    private void nightfall$stopBobView(GameRenderer renderer, PoseStack stack, float partialTick) {
    }

    @Redirect(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"))
    private EntityHitResult nightfall$changePickResult(Entity viewer, Vec3 start, Vec3 end, AABB box, Predicate<Entity> filter, double lengthSqr) {
        Level level = viewer.f_19853_;
        double bestDistSqr = lengthSqr;
        Entity bestEntity = null;
        Vec3 bestPoint = null;
        int boxIndex = -1;
        for (Entity entity : level.m_6249_(viewer, box.m_82400_(1.0), filter)) {
            IOrientedHitBoxes hitBoxesEntity;
            if (!(entity instanceof IOrientedHitBoxes) || (hitBoxesEntity = (IOrientedHitBoxes)entity).includeAABB()) {
                Vec3 point;
                double distSqr;
                AABB aabb = entity.m_142469_().m_82400_((double)entity.m_6143_());
                Optional result = aabb.m_82371_(start, end);
                if (aabb.m_82390_(start)) {
                    if (bestDistSqr >= 0.0) {
                        bestEntity = entity;
                        bestPoint = result.orElse(start);
                        bestDistSqr = 0.0;
                    }
                } else if (result.isPresent() && box.m_82390_((Vec3)result.get()) && ((distSqr = start.m_82557_(point = (Vec3)result.get())) < bestDistSqr || bestDistSqr == 0.0)) {
                    if (entity.m_20201_() == viewer.m_20201_() && !entity.canRiderInteract()) {
                        if (bestDistSqr == 0.0) {
                            bestEntity = entity;
                            bestPoint = point;
                        }
                    } else {
                        bestEntity = entity;
                        bestPoint = point;
                        bestDistSqr = distSqr;
                    }
                }
            }
            if (!(entity instanceof IOrientedHitBoxes)) continue;
            hitBoxesEntity = (IOrientedHitBoxes)entity;
            Vec3 startOrigin = start.m_82546_(entity.m_20182_());
            Vec3 endOrigin = end.m_82546_(entity.m_20182_());
            OBB[] obbs = hitBoxesEntity.getOBBs(1.0f);
            for (int i = 0; i < obbs.length; ++i) {
                double distSqr;
                OBB obb = obbs[i];
                obb.extents = obb.extents.m_82490_(1.0 + (double)entity.m_6143_());
                Optional<Vec3> obbPoint = obb.rayCast(startOrigin, endOrigin);
                if (obb.contains(startOrigin)) {
                    if (!(bestDistSqr >= 0.0)) continue;
                    bestEntity = entity;
                    bestPoint = obbPoint.isPresent() ? obbPoint.get().m_82549_(entity.m_20182_()) : start;
                    bestDistSqr = 0.0;
                    boxIndex = i;
                    continue;
                }
                if (!obbPoint.isPresent() || !box.m_82390_(obbPoint.get().m_82549_(entity.m_20182_())) || !((distSqr = startOrigin.m_82557_(obbPoint.get())) < bestDistSqr) && bestDistSqr != 0.0) continue;
                if (entity.m_20201_() == viewer.m_20201_() && !entity.canRiderInteract()) {
                    if (bestDistSqr != 0.0) continue;
                    bestEntity = entity;
                    bestPoint = obbPoint.get().m_82549_(entity.m_20182_());
                    boxIndex = i;
                    continue;
                }
                bestEntity = entity;
                bestPoint = obbPoint.get().m_82549_(entity.m_20182_());
                bestDistSqr = distSqr;
                boxIndex = i;
            }
        }
        return bestEntity == null ? null : new OrientedEntityHitResult(bestEntity, bestPoint, boxIndex);
    }
}

