/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.client.EntityLightEngine;
import frostnox.nightfall.world.Weather;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeLevel;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelMixin
extends CapabilityProvider<Level>
implements LevelAccessor,
AutoCloseable,
IForgeLevel {
    @Shadow
    protected abstract LevelChunk m_46745_(BlockPos var1);

    private LevelMixin(Class<Level> baseClass) {
        super(baseClass);
    }

    @Inject(method={"onBlockStateChange"}, at={@At(value="HEAD")})
    private void nightfall$onClientBlockStateChange(BlockPos pos, BlockState blockState, BlockState newState, CallbackInfo callbackInfo) {
        EntityLightEngine.get().handleBlockUpdate(pos);
    }

    @Inject(method={"isRainingAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void nightfall$isRainingAt(BlockPos pos, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (LevelData.isPresent((Level)this)) {
            ILevelData capL = LevelData.get((Level)this);
            if (!this.m_45527_(pos) || this.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
                callbackInfo.setReturnValue((Object)false);
            } else {
                LevelChunk chunk = this.m_46745_(pos);
                if (!chunk.m_6430_()) {
                    callbackInfo.setReturnValue((Object)(capL.getWeather(ChunkData.get(this.m_46745_(pos)), pos) == Weather.RAIN ? 1 : 0));
                }
            }
        }
    }

    @Inject(method={"getRainLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void nightfall$getRainLevel(float partialTick, CallbackInfoReturnable<Float> callbackInfo) {
        LazyOptional<ILevelData> capL = LevelData.getOptional((Level)this);
        if (capL.isPresent()) {
            callbackInfo.setReturnValue((Object)Float.valueOf(((ILevelData)capL.orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."))).getGlobalRainLevel()));
        }
    }

    @Inject(method={"getThunderLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void nightfall$getThunderLevel(float partialTick, CallbackInfoReturnable<Float> callbackInfo) {
        LazyOptional<ILevelData> capL = LevelData.getOptional((Level)this);
        if (capL.isPresent()) {
            callbackInfo.setReturnValue((Object)Float.valueOf(((ILevelData)capL.orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."))).getGlobalThunderLevel()));
        }
    }
}

