/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.math.Vector3f;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.world.MoonPhase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LightTexture.class})
public abstract class LightTextureMixin
implements AutoCloseable {
    @Shadow
    @Final
    private Minecraft f_109876_;
    @Shadow
    @Final
    private DynamicTexture f_109870_;
    @Shadow
    @Final
    private NativeImage f_109871_;
    @Shadow
    private boolean f_109873_;
    @Shadow
    private float f_109874_;
    @Shadow
    @Final
    private GameRenderer f_109875_;

    @Shadow
    public abstract float m_109892_(float var1);

    @Shadow
    public abstract float m_109888_(Level var1, int var2);

    @Overwrite
    public void m_109881_(float pPartialTicks) {
        if (this.f_109873_) {
            this.f_109873_ = false;
            this.f_109876_.m_91307_().m_6180_("lightTex");
            ClientLevel clientlevel = this.f_109876_.f_91073_;
            if (clientlevel != null) {
                float skyDarken = clientlevel.m_104805_(1.0f);
                float skyFlash = clientlevel.m_104819_() > 0 ? 1.0f : skyDarken * 0.95f + 0.05f;
                float waterVision = this.f_109876_.f_91074_.m_108639_();
                float nightVision = this.f_109876_.f_91074_.m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)this.f_109876_.f_91074_, (float)pPartialTicks) : (waterVision > 0.0f && this.f_109876_.f_91074_.m_21023_(MobEffects.f_19592_) ? waterVision : (this.f_109876_.f_91074_.m_5833_() && this.f_109876_.f_91074_.f_19853_.m_186437_((Entity)this.f_109876_.f_91074_, new AABB(this.f_109876_.f_91074_.m_146892_().m_82492_(0.001, 0.001, 0.001), this.f_109876_.f_91074_.m_146892_().m_82520_(0.001, 0.001, 0.001))) ? 1.0f : 0.0f));
                Vector3f skyDarkened = new Vector3f(skyDarken, skyDarken, 1.0f);
                skyDarkened.m_122255_(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
                if (skyDarken < 1.0f && LevelData.isPresent((Level)clientlevel)) {
                    MoonPhase phase = MoonPhase.get((LevelTimeAccess)clientlevel);
                    float moonAmount = (float)Math.max(0.0, (double)clientlevel.m_104811_(1.0f) - 0.2) * 10.0f / 3.0f * 2.0f;
                    if (phase == MoonPhase.FULL) {
                        skyDarkened.m_122255_(new Vector3f(0.32f, 0.615f, 1.0f), moonAmount);
                    } else if (phase == MoonPhase.WANING_GIBBOUS || phase == MoonPhase.WAXING_GIBBOUS) {
                        skyDarkened.m_122255_(new Vector3f(0.32f, 0.515f, 1.0f), moonAmount);
                    } else if (phase == MoonPhase.FIRST_QUARTER || phase == MoonPhase.LAST_QUARTER) {
                        skyDarkened.m_122255_(new Vector3f(0.32f, 0.44f, 1.0f), moonAmount);
                    } else if (phase == MoonPhase.WANING_CRESCENT || phase == MoonPhase.WAXING_CRESCENT) {
                        skyDarkened.m_122255_(new Vector3f(0.32f, 0.38f, 1.0f), moonAmount);
                    } else if (phase == MoonPhase.NEW) {
                        skyDarkened.m_122255_(new Vector3f(0.17f, 0.17f, 0.42f), moonAmount);
                    }
                }
                float blockFlicker = this.f_109874_ + 1.5f;
                Vector3f lightColor = new Vector3f();
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        float brightestColor;
                        float skyLight = this.m_109888_((Level)clientlevel, i) * skyFlash;
                        float blockR = this.m_109888_((Level)clientlevel, j) * blockFlicker;
                        float blockG = blockR * ((blockR * 0.6f + 0.4f) * 0.6f + 0.4f);
                        float blockB = blockR * (blockR * blockR * 0.6f + 0.4f);
                        lightColor.m_122245_(blockR, blockG, blockB);
                        if (clientlevel.m_104583_().m_108884_()) {
                            lightColor.m_122255_(new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                        } else {
                            Vector3f skyDarkenedFlash = skyDarkened.m_122281_();
                            skyDarkenedFlash.m_122261_(skyLight);
                            lightColor.m_122253_(skyDarkenedFlash);
                            lightColor.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                            if (this.f_109875_.m_109131_(pPartialTicks) > 0.0f) {
                                float darkenAmount = this.f_109875_.m_109131_(pPartialTicks);
                                Vector3f darkenedLight = lightColor.m_122281_();
                                darkenedLight.m_122263_(0.7f, 0.6f, 0.6f);
                                lightColor.m_122255_(darkenedLight, darkenAmount);
                            }
                        }
                        lightColor.m_122242_(0.0f, 1.0f);
                        if (nightVision > 0.0f && (brightestColor = Math.max(lightColor.m_122239_(), Math.max(lightColor.m_122260_(), lightColor.m_122269_()))) < 1.0f) {
                            float f12 = 1.0f / brightestColor;
                            Vector3f vector3f5 = lightColor.m_122281_();
                            vector3f5.m_122261_(f12);
                            lightColor.m_122255_(vector3f5, nightVision);
                        }
                        float gamma = (float)this.f_109876_.f_91066_.f_92071_ / 4.0f;
                        Vector3f gammaAdjustment = lightColor.m_122281_();
                        gammaAdjustment.m_122258_(this::m_109892_);
                        lightColor.m_122255_(gammaAdjustment, gamma);
                        lightColor.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                        lightColor.m_122242_(0.0f, 1.0f);
                        if (nightVision == 0.0f) {
                            lightColor.m_122261_((float)Math.min(13, Math.max(i, j)) / 13.0f);
                        }
                        lightColor.m_122261_(255.0f);
                        int r = (int)lightColor.m_122239_();
                        int g = (int)lightColor.m_122260_();
                        int b = (int)lightColor.m_122269_();
                        this.f_109871_.m_84988_(j, i, 0xFF000000 | b << 16 | g << 8 | r);
                    }
                }
                this.f_109870_.m_117985_();
            }
            this.f_109876_.m_91307_().m_7238_();
        }
    }
}

