/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import frostnox.nightfall.entity.entity.ActionableEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntityMixin(EntityType<?> pEntityType, Level level) {
        super(pEntityType, level);
    }

    @Redirect(method={"tickDeath"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V"))
    private void nightfall$broadcastPoofParticles(Level level, Entity entity, byte id) {
        if (id != 60 || !(entity instanceof Player)) {
            level.m_7605_(entity, id);
        }
    }

    @ModifyConstant(method={"jumpFromGround"}, constant={@Constant(floatValue=0.2f)})
    private float nightfall$adjustSprintJumpBoost(float value) {
        return 0.125f;
    }

    @Overwrite
    public void m_7334_(Entity pusher) {
        double dZ;
        double dX;
        double maxD;
        if (!this.m_20365_(pusher) && !pusher.f_19794_ && !this.f_19794_ && (maxD = Mth.m_14005_((double)(dX = pusher.m_20185_() - this.m_20185_()), (double)(dZ = pusher.m_20189_() - this.m_20189_()))) >= 0.01) {
            ActionableEntity actionable;
            maxD = Math.sqrt(maxD);
            dX /= maxD;
            dZ /= maxD;
            double scale = 1.0 / maxD;
            if (scale > 1.0) {
                scale = 1.0;
            }
            dX *= scale * 0.05;
            dZ *= scale * 0.05;
            if (!this.m_20160_()) {
                float f;
                if (pusher instanceof ActionableEntity) {
                    actionable = (ActionableEntity)pusher;
                    f = actionable.getPushForce();
                } else {
                    f = 2.0f;
                }
                if (f >= 2.0f) {
                    this.m_5997_(-dX, 0.0, -dZ);
                }
            }
            if (!pusher.m_20160_()) {
                float f;
                if (pusher instanceof ActionableEntity) {
                    actionable = (ActionableEntity)pusher;
                    f = actionable.getPushResistance();
                } else {
                    f = 2.0f;
                }
                if (f <= 2.0f) {
                    pusher.m_5997_(dX, 0.0, dZ);
                }
            }
        }
    }
}

