/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import com.mojang.blaze3d.platform.WindowEventHandler;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.world.Season;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.client.extensions.IForgeMinecraft;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler,
IForgeMinecraft {
    @Shadow
    @Nullable
    private Screen f_91080_;
    @Shadow
    @Nullable
    private LocalPlayer f_91074_;
    @Shadow
    @Final
    private Gui f_91065_;

    private MinecraftMixin(String pName) {
        super(pName);
    }

    @Unique
    private Music getRandomSeasonMusic() {
        return switch (this.f_91074_.m_21187_().nextInt(4)) {
            case 0 -> ClientEngine.get().SPRING_MUSIC;
            case 1 -> ClientEngine.get().SUMMER_MUSIC;
            case 2 -> ClientEngine.get().FALL_MUSIC;
            default -> ClientEngine.get().WINTER_MUSIC;
        };
    }

    @Overwrite
    public Music m_91107_() {
        if (this.f_91080_ instanceof WinScreen) {
            return Musics.f_11647_;
        }
        if (this.f_91074_ == null) {
            return ClientEngine.get().MENU_MUSIC;
        }
        if (this.f_91074_.f_19853_.m_46472_() == Level.f_46430_) {
            return this.f_91065_.m_93090_().m_93713_() ? Musics.f_11648_ : Musics.f_11649_;
        }
        Holder biome = this.f_91074_.f_19853_.m_204166_(this.f_91074_.m_142538_());
        Biome.BiomeCategory category = Biome.m_204183_((Holder)biome);
        if (category == Biome.BiomeCategory.UNDERGROUND) {
            return ((Biome)biome.m_203334_()).m_47566_().orElse(this.getRandomSeasonMusic());
        }
        if (LevelUtil.isDay((LevelAccessor)this.f_91074_.f_19853_) && this.f_91074_.f_19853_.m_45524_(this.f_91074_.m_146901_(), 0) > 0) {
            if (category == Biome.BiomeCategory.OCEAN || !LevelData.isPresent(this.f_91074_.f_19853_)) {
                return ((Biome)biome.m_203334_()).m_47566_().orElse(this.getRandomSeasonMusic());
            }
            return switch (Season.get(this.f_91074_.f_19853_)) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> ClientEngine.get().SPRING_MUSIC;
                case Season.SUMMER -> ClientEngine.get().SUMMER_MUSIC;
                case Season.FALL -> ClientEngine.get().FALL_MUSIC;
                case Season.WINTER -> ClientEngine.get().WINTER_MUSIC;
            };
        }
        return ClientEngine.get().NO_MUSIC;
    }
}

