/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.mixin;

import frostnox.nightfall.block.block.FrazilBlock;
import frostnox.nightfall.block.block.SnowBlock;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.world.MoonPhase;
import frostnox.nightfall.world.Season;
import frostnox.nightfall.world.Weather;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
public abstract class ServerChunkCacheMixin
extends ChunkSource {
    @Shadow
    @Final
    ServerLevel f_8329_;
    @Shadow
    @Final
    ChunkMap f_8325_;
    @Shadow
    long f_8334_;
    @Shadow
    boolean f_8335_;
    @Shadow
    boolean f_8336_;
    @Unique
    private static final int RANDOM_SECTIONS_DIVISOR = 4;
    @Unique
    private static final BlockState SNOW_LAYER = ((SnowBlock)BlocksNF.SNOW.get()).m_49966_();

    @Inject(method={"tickChunks"}, at={@At(value="HEAD")}, cancellable=true)
    private void nightfall$tickChunks(CallbackInfo callbackInfo) {
        if (LevelData.isPresent((Level)this.f_8329_)) {
            LevelChunk chunk;
            callbackInfo.cancel();
            ILevelData capL = LevelData.get((Level)this.f_8329_);
            long gameTime = this.f_8329_.m_46467_();
            long timePassed = gameTime - this.f_8334_;
            this.f_8334_ = gameTime;
            long simGameTime = gameTime - 1L;
            long simSeasonTime = capL.getSeasonTime() - 1L;
            float seasonalTemp = Season.getTemperatureInfluence(simSeasonTime);
            long simDayTime = this.f_8329_.m_46468_() - 1L;
            boolean isDay = LevelUtil.isDay((LevelAccessor)this.f_8329_);
            boolean raining = this.f_8329_.m_46471_();
            boolean thundering = raining && this.f_8329_.m_46470_();
            MoonPhase moonPhase = MoonPhase.get((LevelTimeAccess)this.f_8329_);
            int spawnsMod = 4;
            if (moonPhase == MoonPhase.WANING_CRESCENT || moonPhase == MoonPhase.WAXING_CRESCENT) {
                --spawnsMod;
            } else if (moonPhase == MoonPhase.WANING_GIBBOUS || moonPhase == MoonPhase.WAXING_GIBBOUS || moonPhase == MoonPhase.FULL) {
                ++spawnsMod;
            }
            Random random = this.f_8329_.f_46441_;
            int randomSectionsCount = this.f_8329_.m_151559_() / 4;
            int randomTickSpeed = this.f_8329_.m_46469_().m_46215_(GameRules.f_46143_);
            double randomTickChance = (1.0 - Math.pow(0.999755859375, randomTickSpeed)) / 4.0;
            boolean mobSpawning = this.f_8329_.m_46469_().m_46207_(GameRules.f_46134_);
            boolean spawnEnemies = mobSpawning && this.f_8335_;
            boolean spawnFriendlies = mobSpawning && this.f_8336_;
            int loadedChunks = this.m_142061_();
            ObjectArrayList chunks = new ObjectArrayList(loadedChunks);
            for (ChunkHolder chunkHolder : this.f_8329_.m_7726_().f_8325_.m_140416_()) {
                LevelChunk tickingChunk = chunkHolder.m_140085_();
                if (tickingChunk == null) continue;
                chunks.add(Pair.of((Object)tickingChunk, (Object)chunkHolder));
            }
            Collections.shuffle(chunks);
            for (Pair chunkAndHolder : chunks) {
                long elapsedTime;
                chunk = (LevelChunk)chunkAndHolder.left();
                chunk.m_187632_(timePassed);
                IChunkData capC = ChunkData.get(chunk);
                long lastTickTime = capC.getLastTickingGameTime();
                long l = elapsedTime = lastTickTime == Long.MAX_VALUE ? lastTickTime : simGameTime - lastTickTime;
                if (elapsedTime > 0L) {
                    capC.simulateTime(elapsedTime, simGameTime, simDayTime, simSeasonTime, seasonalTemp, randomTickChance, random);
                }
                capC.setLastTickingGameTime(gameTime);
            }
            for (Pair chunkAndHolder : chunks) {
                double spawnZ;
                double spawnY;
                boolean fullMoon;
                int randI;
                chunk = (LevelChunk)chunkAndHolder.left();
                ChunkPos chunkPos = chunk.m_7697_();
                int minX = chunkPos.m_45604_();
                int minZ = chunkPos.m_45605_();
                IChunkData capC = ChunkData.get(chunk);
                GlobalChunkData.get(chunk).tick();
                capC.tickPhysics();
                if (thundering && random.nextInt(1000000) == 0) {
                    BlockPos lightningPos = this.f_8329_.m_143288_(this.f_8329_.m_46496_(minX, 0, minZ, 15));
                    this.f_8329_.m_5594_(null, lightningPos, SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_8329_.f_46441_.nextFloat() * 0.2f);
                }
                if ((randI = random.nextInt(52)) < 4) {
                    BlockPos randPos = this.f_8329_.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.f_8329_.m_46496_(minX, 0, minZ, 15));
                    BlockPos randPosBelow = randPos.m_7495_();
                    BlockState belowBlock = this.f_8329_.m_8055_(randPosBelow);
                    FluidState belowFluid = belowBlock.m_60819_();
                    if (belowFluid.m_76170_()) {
                        float temperature = capL.getSeasonalTemperature(capC, randPosBelow);
                        if (temperature <= 0.22f) {
                            Block block = belowBlock.m_60734_();
                            if (block == BlocksNF.WATER.get()) {
                                this.f_8329_.m_46597_(randPos, ((FrazilBlock)BlocksNF.FRAZIL.get()).m_49966_());
                            } else if (block == BlocksNF.SEAWATER.get() && temperature <= 0.07f) {
                                this.f_8329_.m_46597_(randPos, ((FrazilBlock)BlocksNF.SEA_FRAZIL.get()).m_49966_());
                            }
                        }
                    } else {
                        Weather weather = capL.getWeather(capC, randPos);
                        if (weather.isPrecipitation) {
                            Biome.Precipitation precipitation;
                            switch (weather) {
                                case RAIN: {
                                    Biome.Precipitation precipitation2 = Biome.Precipitation.RAIN;
                                    break;
                                }
                                case SNOW: {
                                    Biome.Precipitation precipitation2 = Biome.Precipitation.SNOW;
                                    break;
                                }
                                default: {
                                    Biome.Precipitation precipitation2 = precipitation = Biome.Precipitation.NONE;
                                }
                            }
                            if (precipitation == Biome.Precipitation.SNOW && !belowBlock.m_204336_(BlockTags.f_13047_) && this.f_8329_.m_8055_(randPos).m_60795_() && Block.m_49918_((VoxelShape)belowBlock.m_60816_((BlockGetter)this.f_8329_, randPosBelow), (Direction)Direction.UP)) {
                                this.f_8329_.m_46597_(randPos, SNOW_LAYER);
                            }
                            belowBlock.m_60734_().m_141997_(belowBlock, (Level)this.f_8329_, randPosBelow, precipitation);
                        }
                    }
                }
                if (randomTickSpeed > 0) {
                    int sectionOffset = randI % 4 * randomSectionsCount;
                    LevelChunkSection[] sections = chunk.m_7103_();
                    for (int i = sectionOffset; i < sectionOffset + randomSectionsCount; ++i) {
                        LevelChunkSection section = sections[i];
                        if (!section.m_63014_()) continue;
                        int bottomY = section.m_63017_();
                        for (int j = 0; j < randomTickSpeed; ++j) {
                            FluidState fluid;
                            BlockPos randomPos = this.f_8329_.m_46496_(minX, bottomY, minZ, 15);
                            BlockState block = section.m_62982_(randomPos.m_123341_() - minX, randomPos.m_123342_() - bottomY, randomPos.m_123343_() - minZ);
                            if (block.m_60823_()) {
                                block.m_60735_(this.f_8329_, randomPos, random);
                            }
                            if (!(fluid = block.m_60819_()).m_76187_()) continue;
                            fluid.m_76174_((Level)this.f_8329_, randomPos, random);
                        }
                    }
                }
                if (mobSpawning) {
                    capC.tryEntitySpawn(spawnFriendlies, spawnEnemies);
                }
                if (isDay) {
                    if (!capC.hasSpawnedUndead()) continue;
                    capC.clearUndeadUUIDs();
                    capC.setSpawnedUndead(false);
                    chunk.m_8092_(true);
                    continue;
                }
                if (moonPhase == MoonPhase.NEW || random.nextInt(2048) != 0) continue;
                boolean bl = fullMoon = moonPhase == MoonPhase.FULL;
                BlockPos centerPos = LevelUtil.getRandomSurfacePos((Level)this.f_8329_, chunk);
                double spawnX = (double)centerPos.m_123341_() + 0.5;
                double maxDist = LevelUtil.getShortestDistanceSqrUndeadMaxToPlayer((Level)this.f_8329_, spawnX, spawnY = (double)centerPos.m_123342_(), spawnZ = (double)centerPos.m_123343_() + 0.5, fullMoon);
                if (!(maxDist < 16384.0)) continue;
                boolean bl2 = !fullMoon;
                if (!(LevelUtil.getShortestDistanceSqrUndeadMinToPlayer((Level)this.f_8329_, spawnX, spawnY, spawnZ, bl2) > 576.0)) continue;
                if (!capC.hasSpawnedUndead() && random.nextFloat() < (fullMoon ? 0.87f : 0.9f) || !fullMoon && this.isUndeadSpawnBlocked(centerPos, chunk, chunkPos)) {
                    capC.setSpawnedUndead(true);
                    chunk.m_8092_(true);
                    continue;
                }
                if (capC.hasSpawnedUndead() && (!fullMoon || !(maxDist < 4096.0) || capC.areUndeadLoaded()) || !spawnEnemies) continue;
                ObjectArrayList types = ObjectArrayList.of((Object[])new EntityType[]{(EntityType)EntitiesNF.HUSK.get(), (EntityType)EntitiesNF.SKELETON.get()});
                int supportWeight = 2;
                for (int i = 0; i < (random.nextInt() & Integer.MAX_VALUE) % spawnsMod; ++i) {
                    float supportThreshold = (float)supportWeight / ((float)supportWeight + 2.0f);
                    float rand = random.nextFloat();
                    if (rand < supportThreshold) {
                        types.add((Object)((EntityType)EntitiesNF.DREG.get()));
                        if (supportWeight <= 0) continue;
                        --supportWeight;
                        continue;
                    }
                    if (rand < supportThreshold + (1.0f - supportThreshold) / 2.0f) {
                        types.add((Object)((EntityType)EntitiesNF.HUSK.get()));
                        continue;
                    }
                    types.add((Object)((EntityType)EntitiesNF.SKELETON.get()));
                }
                ObjectArrayList openPositions = ObjectArrayList.of();
                int xDist = 1;
                int zDist = 1;
                while (openPositions.size() < types.size()) {
                    for (int x = -xDist; x <= xDist; x += xDist) {
                        for (int z = -zDist; z <= zDist; z += zDist) {
                            BlockPos pos;
                            int zPos;
                            int xPos;
                            if (x == 0 && z == 0 || !this.f_8329_.m_151577_(xPos = centerPos.m_123341_() + x, zPos = centerPos.m_123343_() + z) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.f_8329_, (BlockPos)(pos = new BlockPos(xPos, this.f_8329_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, xPos, zPos), zPos)), (EntityType)((EntityType)EntitiesNF.HUSK.get()))) continue;
                            openPositions.add((Object)pos);
                        }
                    }
                    ++zDist;
                    if (++xDist <= 4) continue;
                }
                if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.f_8329_, (BlockPos)centerPos, (EntityType)((EntityType)EntitiesNF.HUSK.get()))) {
                    openPositions.add((Object)centerPos);
                }
                for (int i = 0; i < types.size() && !openPositions.isEmpty(); ++i) {
                    ObjectArrayList positions = openPositions.clone();
                    BlockPos pos = (BlockPos)positions.remove((random.nextInt() & Integer.MAX_VALUE) % positions.size());
                    EntityType type = (EntityType)types.get(i);
                    PathfinderMob entity = (PathfinderMob)type.m_20615_((Level)this.f_8329_);
                    entity.m_20035_(pos, random.nextFloat() * 360.0f, 0.0f);
                    if (!entity.m_5545_((LevelAccessor)this.f_8329_, MobSpawnType.NATURAL)) continue;
                    int spawnsLeft = types.size() - i;
                    boolean cancelSpawn = false;
                    while (!entity.m_6914_((LevelReader)this.f_8329_)) {
                        if (spawnsLeft <= positions.size()) {
                            cancelSpawn = true;
                            break;
                        }
                        pos = (BlockPos)positions.remove((random.nextInt() & Integer.MAX_VALUE) % positions.size());
                    }
                    if (cancelSpawn) break;
                    openPositions.remove((Object)pos);
                    entity.m_6518_((ServerLevelAccessor)this.f_8329_, this.f_8329_.m_6436_(pos), MobSpawnType.NATURAL, null, null);
                    this.f_8329_.m_47205_((Entity)entity);
                    capC.addUndeadUUID(entity.m_142081_());
                }
                capC.setSpawnedUndead(true);
                chunk.m_8092_(true);
            }
            for (Pair chunkAndHolder : chunks) {
                ((ChunkHolder)chunkAndHolder.right()).m_140054_((LevelChunk)chunkAndHolder.left());
            }
            this.f_8325_.m_140421_();
        }
    }

    @Unique
    private boolean isUndeadSpawnBlocked(BlockPos spawnPos, LevelChunk centerChunk, ChunkPos chunkPos) {
        if (ChunkData.get(centerChunk).isUndeadSpawnBlocked(spawnPos)) {
            return true;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || !ChunkData.get(this.f_8329_.m_6325_(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z)).isUndeadSpawnBlocked(spawnPos)) continue;
                return true;
            }
        }
        return false;
    }
}

