/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.network.command.argument.KnowledgeArgument;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.RegistriesNF;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;

public class KnowledgeCommand {
    public static final String FORGET_SELF = "nightfall.command.knowledge.forget.self";
    public static final String FORGET = "nightfall.command.knowledge.forget";
    public static final String FORGET_OTHER = "nightfall.command.knowledge.forget.other";
    public static final TranslatableComponent FORGET_ALL_SELF = new TranslatableComponent("nightfall.command.knowledge.forget_all.self");
    public static final TranslatableComponent FORGET_ALL = new TranslatableComponent("nightfall.command.knowledge.forget_all");
    public static final String FORGET_ALL_OTHER = "nightfall.command.knowledge.forget_all.other";
    public static final String LEARN_SELF = "nightfall.command.knowledge.learn.self";
    public static final String LEARN = "nightfall.command.knowledge.learn";
    public static final String LEARN_OTHER = "nightfall.command.knowledge.learn.other";
    public static final TranslatableComponent LEARN_ALL_SELF = new TranslatableComponent("nightfall.command.knowledge.learn_all.self");
    public static final TranslatableComponent LEARN_ALL = new TranslatableComponent("nightfall.command.knowledge.learn_all");
    public static final String LEARN_ALL_OTHER = "nightfall.command.knowledge.learn_all.other";

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"knowledge").requires(sourceStack -> sourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"forget").then(KnowledgeCommand.executeAll(Commands.m_82127_((String)"all"), Action.FORGET_ALL))).then(KnowledgeCommand.execute(Commands.m_82129_((String)"knowledge", (ArgumentType)KnowledgeArgument.id()).suggests(KnowledgeCommand::suggest), Action.FORGET)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"learn").then(KnowledgeCommand.executeAll(Commands.m_82127_((String)"all"), Action.LEARN_ALL))).then(KnowledgeCommand.execute(Commands.m_82129_((String)"knowledge", (ArgumentType)KnowledgeArgument.id()).suggests(KnowledgeCommand::suggest), Action.LEARN)));
        pDispatcher.register(builder);
    }

    private static CompletableFuture<Suggestions> suggest(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82957_(RegistriesNF.getActiveServerKnowledge().stream().map(knowledge -> knowledge.getRegistryName()), (SuggestionsBuilder)builder);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> execute(ArgumentBuilder<CommandSourceStack, ?> builder, Action action) {
        return builder.executes(context -> KnowledgeCommand.handle((CommandContext<CommandSourceStack>)context, KnowledgeArgument.getKnowledge((CommandContext<CommandSourceStack>)context, "knowledge"), action, Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> KnowledgeCommand.handle((CommandContext<CommandSourceStack>)context, KnowledgeArgument.getKnowledge((CommandContext<CommandSourceStack>)context, "knowledge"), action, EntityArgument.m_91477_((CommandContext)context, (String)"target"))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> executeAll(ArgumentBuilder<CommandSourceStack, ?> builder, Action action) {
        return builder.executes(context -> KnowledgeCommand.handle((CommandContext<CommandSourceStack>)context, null, action, Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> KnowledgeCommand.handle((CommandContext<CommandSourceStack>)context, null, action, EntityArgument.m_91477_((CommandContext)context, (String)"target"))));
    }

    private static int handle(CommandContext<CommandSourceStack> context, @Nullable ResourceLocation knowledgeId, Action action, Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            String text;
            TranslatableComponent component;
            IPlayerData capP = PlayerData.get((Player)player);
            Knowledge knowledge = KnowledgeNF.get(knowledgeId);
            switch (action) {
                case FORGET: {
                    capP.removeKnowledge(knowledgeId);
                    break;
                }
                case FORGET_ALL: {
                    for (Knowledge k : RegistriesNF.getActiveServerKnowledge()) {
                        capP.removeKnowledge(k.getRegistryName());
                    }
                    break;
                }
                case LEARN: {
                    capP.addKnowledge(knowledgeId);
                    break;
                }
                case LEARN_ALL: {
                    for (Knowledge k : RegistriesNF.getActiveServerKnowledge()) {
                        if (capP.hasKnowledge(k.getRegistryName())) continue;
                        capP.addKnowledge(k.getRegistryName());
                    }
                    break;
                }
            }
            CommandSourceStack pSource = (CommandSourceStack)context.getSource();
            if (pSource.m_81373_() == player) {
                component = switch (action) {
                    default -> throw new IncompatibleClassChangeError();
                    case Action.FORGET -> new TranslatableComponent(FORGET_SELF, new Object[]{new TranslatableComponent(knowledge.getDescriptionId())});
                    case Action.FORGET_ALL -> FORGET_ALL_SELF;
                    case Action.LEARN -> new TranslatableComponent(LEARN_SELF, new Object[]{new TranslatableComponent(knowledge.getDescriptionId())});
                    case Action.LEARN_ALL -> LEARN_ALL_SELF;
                };
                pSource.m_81354_((Component)component, true);
                continue;
            }
            if (pSource.m_81372_().m_46469_().m_46207_(GameRules.f_46144_)) {
                component = switch (action) {
                    default -> throw new IncompatibleClassChangeError();
                    case Action.FORGET -> new TranslatableComponent(FORGET, new Object[]{new TranslatableComponent(knowledge.getDescriptionId())});
                    case Action.FORGET_ALL -> FORGET_ALL;
                    case Action.LEARN -> new TranslatableComponent(LEARN, new Object[]{new TranslatableComponent(knowledge.getDescriptionId())});
                    case Action.LEARN_ALL -> LEARN_ALL;
                };
                player.m_6352_((Component)component, Util.f_137441_);
            }
            switch (action) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case FORGET: {
                    String string = FORGET_OTHER;
                    break;
                }
                case FORGET_ALL: {
                    String string = FORGET_ALL_OTHER;
                    break;
                }
                case LEARN: {
                    String string = LEARN_OTHER;
                    break;
                }
                case LEARN_ALL: {
                    String string = text = LEARN_ALL_OTHER;
                }
            }
            if (knowledgeId == null) {
                pSource.m_81354_((Component)new TranslatableComponent(text, new Object[]{player.m_5446_()}), true);
                continue;
            }
            pSource.m_81354_((Component)new TranslatableComponent(text, new Object[]{player.m_5446_(), new TranslatableComponent(knowledge.getDescriptionId())}), true);
        }
        return players.size();
    }

    private static enum Action {
        FORGET,
        FORGET_ALL,
        LEARN,
        LEARN_ALL;

    }
}

