/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;

public class ReselectAttributesCommand {
    public static final TranslatableComponent RESELECT = new TranslatableComponent("commands.reselect_attributes.enable");
    public static final String RESELECT_OTHER = "commands.reselect_attributes.enable.other";

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reselectattributes").requires(sourceStack -> sourceStack.m_6761_(2))).executes(context -> ReselectAttributesCommand.reselect((CommandContext<CommandSourceStack>)context, Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_())))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> ReselectAttributesCommand.reselect((CommandContext<CommandSourceStack>)context, EntityArgument.m_91477_((CommandContext)context, (String)"target"))));
        pDispatcher.register(builder);
    }

    private static int reselect(CommandContext<CommandSourceStack> pSource, Collection<ServerPlayer> pPlayers) {
        int count = 0;
        for (ServerPlayer player : pPlayers) {
            if (!player.m_6084_()) continue;
            IPlayerData capP = PlayerData.get((Player)player);
            capP.setNeedsAttributeSelection(true);
            NetworkHandler.toClient(player, new GenericEntityToClient(NetworkHandler.Type.OPEN_ATTRIBUTE_SELECTION_SCREEN_CLIENT, player.m_142049_()));
            ReselectAttributesCommand.logChange((CommandSourceStack)pSource.getSource(), player);
            ++count;
        }
        return count;
    }

    private static void logChange(CommandSourceStack pSource, ServerPlayer player) {
        if (pSource.m_81373_() == player) {
            pSource.m_81354_((Component)RESELECT, true);
        } else {
            if (pSource.m_81372_().m_46469_().m_46207_(GameRules.f_46144_)) {
                player.m_6352_((Component)RESELECT, Util.f_137441_);
            }
            pSource.m_81354_((Component)new TranslatableComponent(RESELECT_OTHER, new Object[]{player.m_5446_()}), true);
        }
    }
}

