/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.LevelDataToClient;
import frostnox.nightfall.world.Season;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class SeasonCommand {
    public static final String QUERY = "commands.time.season.query";
    public static final String SET = "commands.time.season.set";

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"season").requires(context -> context.m_6761_(2) && LevelData.isPresent((Level)context.m_81372_()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"spring").executes(context -> SeasonCommand.setSeason((CommandSourceStack)context.getSource(), Season.SPRING)))).then(Commands.m_82127_((String)"summer").executes(context -> SeasonCommand.setSeason((CommandSourceStack)context.getSource(), Season.SUMMER)))).then(Commands.m_82127_((String)"fall").executes(context -> SeasonCommand.setSeason((CommandSourceStack)context.getSource(), Season.FALL)))).then(Commands.m_82127_((String)"winter").executes(context -> SeasonCommand.setSeason((CommandSourceStack)context.getSource(), Season.WINTER))))).then(Commands.m_82127_((String)"query").executes(context -> SeasonCommand.querySeason((CommandSourceStack)context.getSource(), LevelData.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getSeason()))));
    }

    private static int querySeason(CommandSourceStack pSource, Season season) {
        pSource.m_81354_((Component)new TranslatableComponent(QUERY, new Object[]{season.toTranslatable()}), false);
        return 1;
    }

    private static int setSeason(CommandSourceStack pSource, Season season) {
        ServerLevel level = pSource.m_81372_();
        ILevelData cap = LevelData.get((Level)level);
        cap.setSeasonTime(season.getMiddleTime());
        LevelDataToClient message = new LevelDataToClient(cap.writeNBTSync(new CompoundTag()));
        for (ServerPlayer player : level.m_6907_()) {
            NetworkHandler.toClient(player, message);
        }
        pSource.m_81354_((Component)new TranslatableComponent(SET, new Object[]{season.toTranslatable()}), true);
        return 1;
    }
}

