/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.LevelDataToClient;
import frostnox.nightfall.world.Weather;
import java.text.DecimalFormat;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class WeatherCommandNF {
    public static final String QUERY = "commands.time.weather.query";
    public static final String SET = "commands.time.weather.set";
    private static final DecimalFormat FORMAT = new DecimalFormat("0.000");

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"weather").requires(context -> context.m_6761_(2) && LevelData.isPresent((Level)context.m_81372_()))).then(Commands.m_82129_((String)"threshold", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)1.0f)).executes(context -> WeatherCommandNF.setWeather((CommandSourceStack)context.getSource(), FloatArgumentType.getFloat((CommandContext)context, (String)"threshold"))))).then(Commands.m_82127_((String)"clear").executes(context -> WeatherCommandNF.setWeather((CommandSourceStack)context.getSource(), -0.2f)))).then(Commands.m_82127_((String)"clouds").executes(context -> WeatherCommandNF.setWeather((CommandSourceStack)context.getSource(), 0.2f)))).then(Commands.m_82127_((String)"precipitation").executes(context -> WeatherCommandNF.setWeather((CommandSourceStack)context.getSource(), 0.6f)))).then(Commands.m_82127_((String)"fog").executes(context -> WeatherCommandNF.setWeather((CommandSourceStack)context.getSource(), -0.6f)))).then(Commands.m_82127_((String)"query").executes(context -> WeatherCommandNF.queryWeather((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> WeatherCommandNF.addWeather((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
    }

    private static int queryWeather(CommandSourceStack source) throws CommandSyntaxException {
        Weather weather;
        ServerLevel level = source.m_81372_();
        ILevelData capL = LevelData.get((Level)level);
        if (source.m_81373_() != null) {
            BlockPos pos = source.m_81374_().m_146901_();
            weather = capL.getWeather(ChunkData.get(level.m_46745_(pos)), pos);
        } else {
            weather = capL.getGlobalWeather();
        }
        source.m_81354_((Component)new TranslatableComponent(QUERY, new Object[]{weather.toTranslatable(), FORMAT.format(capL.getGlobalWeatherIntensity()), FORMAT.format(capL.getLastWeatherIntensity()), FORMAT.format(capL.getTargetWeatherIntensity())}), false);
        return 1;
    }

    private static int addWeather(CommandSourceStack source, int amount) throws CommandSyntaxException {
        Weather weather;
        ServerLevel level = source.m_81372_();
        ILevelData capL = LevelData.get((Level)level);
        capL.setGlobalWeatherIntensity(Mth.m_14036_((float)(capL.getGlobalWeatherIntensity() + (float)amount), (float)-1.0f, (float)1.0f));
        LevelDataToClient message = new LevelDataToClient(capL.writeNBTSync(new CompoundTag()));
        for (ServerPlayer player : level.m_6907_()) {
            NetworkHandler.toClient(player, message);
        }
        if (source.m_81373_() != null) {
            BlockPos pos = source.m_81374_().m_146901_();
            weather = capL.getWeather(ChunkData.get(level.m_46745_(pos)), pos);
        } else {
            weather = capL.getGlobalWeather();
        }
        source.m_81354_((Component)new TranslatableComponent(SET, new Object[]{weather.toTranslatable(), Float.valueOf(capL.getGlobalWeatherIntensity())}), true);
        return 1;
    }

    private static int setWeather(CommandSourceStack source, float threshold) throws CommandSyntaxException {
        Weather weather;
        ServerLevel level = source.m_81372_();
        ILevelData capL = LevelData.get((Level)level);
        capL.setGlobalWeatherIntensity(threshold);
        LevelDataToClient message = new LevelDataToClient(capL.writeNBTSync(new CompoundTag()));
        for (ServerPlayer player : level.m_6907_()) {
            NetworkHandler.toClient(player, message);
        }
        if (source.m_81373_() != null) {
            BlockPos pos = source.m_81374_().m_146901_();
            weather = capL.getWeather(ChunkData.get(level.m_46745_(pos)), pos);
        } else {
            weather = capL.getGlobalWeather();
        }
        source.m_81354_((Component)new TranslatableComponent(SET, new Object[]{weather.toTranslatable(), Float.valueOf(threshold)}), true);
        return 1;
    }
}

