/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import frostnox.nightfall.registry.RegistriesNF;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class EntryArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = List.of("nightfall:basic_tools");
    public static final String INVALID = "nightfall.command.entry.not_found";
    private static final DynamicCommandExceptionType ERROR = new DynamicCommandExceptionType(name -> new TranslatableComponent(INVALID, new Object[]{name}));

    public static EntryArgument id() {
        return new EntryArgument();
    }

    public static ResourceLocation getEntry(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        return EntryArgument.verify((ResourceLocation)pContext.getArgument(pName, ResourceLocation.class));
    }

    private static ResourceLocation verify(ResourceLocation id) throws CommandSyntaxException {
        if (!RegistriesNF.getEntries().containsKey(id)) {
            throw ERROR.create((Object)id);
        }
        return id;
    }

    public ResourceLocation parse(StringReader pReader) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)pReader);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

