/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.EntityLightEngine;
import frostnox.nightfall.entity.IChaser;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.entity.entity.monster.UndeadEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.registry.ActionsNF;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class GenericEntityToClient {
    private NetworkHandler.Type messageType;
    private int entityID;
    private boolean isValid;

    public GenericEntityToClient(NetworkHandler.Type messageType, int entityID) {
        this.messageType = messageType;
        this.entityID = entityID;
        this.isValid = true;
    }

    private GenericEntityToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130068_((Enum)this.messageType);
            b.writeInt(this.entityID);
        }
    }

    public static GenericEntityToClient read(FriendlyByteBuf b) {
        GenericEntityToClient msg = new GenericEntityToClient();
        msg.messageType = (NetworkHandler.Type)b.m_130066_(NetworkHandler.Type.class);
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(GenericEntityToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> GenericEntityToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("GenericMessageToClient with " + msg.messageType + " received on server.");
        }
    }

    private static void doClientWork(GenericEntityToClient msg, Level world) {
        block37: {
            LivingEntity entity;
            block36: {
                Entity baseEntity = world.m_6815_(msg.entityID);
                if (msg.messageType == NetworkHandler.Type.MOVING_BLOCK_SET_AIR_CLIENT) {
                    if (baseEntity instanceof MovingBlockEntity) {
                        MovingBlockEntity entity2 = (MovingBlockEntity)baseEntity;
                        entity2.setBlockState(Blocks.f_50016_.m_49966_());
                    } else {
                        Nightfall.LOGGER.error(GenericEntityToClient.class.getName() + " message " + msg.messageType + " cannot be applied to non MovingBlockEntity");
                    }
                    return;
                }
                if (msg.messageType == NetworkHandler.Type.MOVING_BLOCK_STOP_PHYSICS_CLIENT) {
                    if (baseEntity instanceof MovingBlockEntity) {
                        MovingBlockEntity entity3 = (MovingBlockEntity)baseEntity;
                        entity3.f_19794_ = true;
                        entity3.queueDiscard();
                    } else {
                        Nightfall.LOGGER.error(GenericEntityToClient.class.getName() + " message " + msg.messageType + " cannot be applied to non MovingBlockEntity");
                    }
                    return;
                }
                if (msg.messageType == NetworkHandler.Type.CHASER_ACQUIRE_TARGET_CLIENT || msg.messageType == NetworkHandler.Type.CHASER_REMOVE_TARGET_CLIENT) {
                    if (baseEntity instanceof IChaser) {
                        IChaser chaser = (IChaser)baseEntity;
                        chaser.setChasing(msg.messageType == NetworkHandler.Type.CHASER_ACQUIRE_TARGET_CLIENT);
                    } else {
                        Nightfall.LOGGER.error(GenericEntityToClient.class.getName() + " message " + msg.messageType + " cannot be applied to non IChaser entity");
                    }
                    return;
                }
                if (baseEntity == null) {
                    Nightfall.LOGGER.warn(GenericEntityToClient.class.getName() + " Entity is null.");
                    return;
                }
                if (msg.messageType == NetworkHandler.Type.ADD_LIGHT_SOURCE_CLIENT) {
                    EntityLightEngine.get().addLightSource(baseEntity);
                    return;
                }
                if (msg.messageType == NetworkHandler.Type.REMOVE_LIGHT_SOURCE_CLIENT) {
                    EntityLightEngine.get().removeLightSource(baseEntity);
                    return;
                }
                if (!(baseEntity instanceof LivingEntity)) {
                    Nightfall.LOGGER.warn(GenericEntityToClient.class.getName() + " Entity is invalid type.");
                    return;
                }
                entity = (LivingEntity)baseEntity;
                if (msg.messageType == NetworkHandler.Type.RESURRECT_UNDEAD_CLIENT) {
                    if (entity instanceof UndeadEntity) {
                        UndeadEntity undead = (UndeadEntity)entity;
                        undead.resurrect();
                    }
                    return;
                }
                if (!entity.m_6084_()) {
                    Nightfall.LOGGER.warn(GenericEntityToClient.class.getName() + " Entity is dead.");
                    return;
                }
                if (!(entity instanceof Player)) break block36;
                Player player = (Player)entity;
                IPlayerData capP = PlayerData.get(player);
                IActionTracker capA = ActionTracker.get((Entity)player);
                switch (msg.messageType) {
                    case BLOCK_CLIENT: {
                        capP.setLastBlockTick(player.f_19797_);
                        break;
                    }
                    case ACTIVATE_MAINHAND: {
                        capP.setMainhandActive();
                        break;
                    }
                    case ACTIVATE_OFFHAND: {
                        capP.setOffhandActive();
                        break;
                    }
                    case START_CRAWLING: {
                        capP.setCrawling(true);
                        break;
                    }
                    case STOP_CRAWLING: {
                        capP.setCrawling(false);
                        break;
                    }
                    case START_CLIMBING: {
                        capP.setClimbing(true);
                        break;
                    }
                    case STOP_CLIMBING: {
                        capP.setClimbing(false);
                        break;
                    }
                    case STOP_HOLDING_CLIENT: {
                        capA.startAction(ActionsNF.EMPTY.getId());
                        capP.setHeldContents(new CompoundTag());
                        break;
                    }
                    case QUEUE_ACTION_TRACKER: {
                        capA.queue();
                        break;
                    }
                    case HITSTOP_CLIENT: {
                        if (capA.isDamaging()) {
                            capP.setHitStopFrame(capA.getAction().getBlockHitFrame(capA.getState(), (LivingEntity)player));
                            break;
                        }
                        break block37;
                    }
                    case HIT_PAUSE_CLIENT: {
                        capA.setHitPause(ClientEngine.get().getPartialTick());
                        break;
                    }
                    case OPEN_ATTRIBUTE_SELECTION_SCREEN_CLIENT: {
                        ClientEngine.get().openAttributeSelectionScreen();
                        break;
                    }
                    case PUZZLE_EXPERIMENT_FAIL_CLIENT: {
                        ClientEngine.get().playExperimentSound(false);
                        break;
                    }
                    case PUZZLE_EXPERIMENT_SUCCESS_CLIENT: {
                        ClientEngine.get().playExperimentSound(true);
                        break;
                    }
                    default: {
                        Nightfall.LOGGER.warn("No player handler in " + GenericEntityToClient.class.getSimpleName() + " for message " + msg.messageType);
                        break;
                    }
                }
                break block37;
            }
            IActionTracker capA = ActionTracker.get((Entity)entity);
            switch (msg.messageType) {
                case QUEUE_ACTION_TRACKER: {
                    capA.queue();
                    break;
                }
                default: {
                    Nightfall.LOGGER.warn("No entity handler in " + GenericEntityToClient.class.getSimpleName() + " for message " + msg.messageType);
                }
            }
        }
    }
}

