/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.encyclopedia.PuzzleContainer;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.capability.ActionTrackerToClient;
import frostnox.nightfall.world.inventory.PlayerInventoryContainer;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class GenericToServer {
    private NetworkHandler.Type messageType;
    private boolean isValid;

    public GenericToServer(NetworkHandler.Type messageType) {
        this.messageType = messageType;
        this.isValid = true;
    }

    private GenericToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130068_((Enum)this.messageType);
        }
    }

    public static GenericToServer read(FriendlyByteBuf b) {
        GenericToServer msg = new GenericToServer();
        msg.messageType = (NetworkHandler.Type)b.m_130066_(NetworkHandler.Type.class);
        msg.isValid = true;
        return msg;
    }

    public static void handle(GenericToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("GenericToServer with " + msg.messageType + " received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> GenericToServer.doServerWork(msg, player));
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null.");
            }
        }
    }

    private static void doServerWork(GenericToServer msg, ServerPlayer player) {
        if (!player.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        switch (msg.messageType) {
            case PUZZLE_EXPERIMENT_SERVER: {
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof PuzzleContainer) {
                    PuzzleContainer container = (PuzzleContainer)abstractContainerMenu;
                    if (capP.hasEntryStage(container.entry.getRegistryName(), EntryStage.PUZZLE) && container.entry.puzzle != null) {
                        if (container.entry.puzzle.isSolved(capP, container.inventory)) {
                            capP.advanceStage(container.entry.getRegistryName());
                            NetworkHandler.toClient(player, new GenericEntityToClient(NetworkHandler.Type.PUZZLE_EXPERIMENT_SUCCESS_CLIENT, player.m_142049_()));
                        } else {
                            IntList icons = container.entry.puzzle.getItemIcons(container.inventory);
                            for (int i = 0; i < icons.size(); ++i) {
                                container.itemIcons.set(i, icons.getInt(i));
                            }
                            NetworkHandler.toClient(player, new GenericEntityToClient(NetworkHandler.Type.PUZZLE_EXPERIMENT_FAIL_CLIENT, player.m_142049_()));
                        }
                        container.inventory.clear();
                        return;
                    }
                }
                Nightfall.LOGGER.error("Player " + player.m_7755_().getString() + " tried to solve puzzle but does not have access to entry");
                break;
            }
            case CLOSE_RECIPE_SEARCH_SERVER: {
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof PlayerInventoryContainer)) break;
                PlayerInventoryContainer container = (PlayerInventoryContainer)abstractContainerMenu;
                container.clearSearchSlot();
                break;
            }
            case ACTIVATE_MAINHAND: {
                if (!capA.isInactive() && !capA.getAction().isInterruptible() && (capA.getState() != capA.getAction().getTotalStates() - 1 || capA.getFrame() != capA.getDuration())) break;
                capP.setMainhandActive();
                NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.ACTIVATE_MAINHAND, player.m_142049_()));
                break;
            }
            case ACTIVATE_OFFHAND: {
                if (!capA.isInactive() && !capA.getAction().isInterruptible() && (capA.getState() != capA.getAction().getTotalStates() - 1 || capA.getFrame() != capA.getDuration())) break;
                capP.setOffhandActive();
                NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.ACTIVATE_OFFHAND, player.m_142049_()));
                break;
            }
            case START_CRAWLING: {
                if (capA.isInactive() || capA.getAction().isInterruptible()) {
                    capP.setCrawling(true);
                    player.m_20124_(Pose.SWIMMING);
                    player.m_6858_(false);
                    break;
                }
                NetworkHandler.toClient(player, new GenericEntityToClient(NetworkHandler.Type.STOP_CRAWLING, player.m_142049_()));
                break;
            }
            case STOP_CRAWLING: {
                if (capA.isInactive() || capA.getAction().isInterruptible()) {
                    capP.setCrawling(false);
                    break;
                }
                NetworkHandler.toClient(player, new GenericEntityToClient(NetworkHandler.Type.START_CRAWLING, player.m_142049_()));
                break;
            }
            case START_CLIMBING: {
                capP.setClimbing(true);
                NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.START_CLIMBING, player.m_142049_()));
                break;
            }
            case STOP_CLIMBING: {
                capP.setClimbing(false);
                NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.STOP_CLIMBING, player.m_142049_()));
                break;
            }
            case QUEUE_ACTION_TRACKER: {
                Action action = capA.getAction();
                if (capA.isCharging()) {
                    capA.queue();
                    NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.QUEUE_ACTION_TRACKER, player.m_142049_()));
                    break;
                }
                if (!(((Action)((Object)action.getChain((LivingEntity)player).get())).isEmpty() || capA.getState() != action.getChainState() && capA.getState() != action.getChainState() - 1)) {
                    capA.queue();
                    NetworkHandler.toAllTracking((Entity)player, new GenericEntityToClient(NetworkHandler.Type.QUEUE_ACTION_TRACKER, player.m_142049_()));
                    break;
                }
                if (capA.getState() <= action.getChargeState() + 1 && capA.getFrame() <= 2 && !((Action)((Object)action.chainsFrom().get())).isEmpty()) break;
                NetworkHandler.toClient(player, new ActionTrackerToClient(capA.writeNBT(), player.m_142049_()));
                break;
            }
            default: {
                Nightfall.LOGGER.error("No handler in " + GenericToServer.class.getSimpleName() + " for message " + msg.messageType);
            }
        }
    }
}

