/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.blockentity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.mold.ItemMoldBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class BlockEntityFluidToClient {
    private boolean isValid;
    private BlockPos blockEntityPos;
    private FluidStack fluidResult;

    public BlockEntityFluidToClient(BlockPos blockEntityPos, FluidStack fluidResult) {
        this.blockEntityPos = blockEntityPos;
        this.fluidResult = fluidResult;
        this.isValid = true;
    }

    private BlockEntityFluidToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130064_(this.blockEntityPos);
            b.writeFluidStack(this.fluidResult);
            b.m_130068_((Enum)TieredHeat.RED);
        }
    }

    public static BlockEntityFluidToClient read(FriendlyByteBuf b) {
        BlockEntityFluidToClient msg = new BlockEntityFluidToClient();
        msg.blockEntityPos = b.m_130135_();
        msg.fluidResult = b.readFluidStack();
        msg.isValid = true;
        return msg;
    }

    public static void handle(BlockEntityFluidToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("ClientLevel does not exist.");
                    return;
                }
                if (!((Level)world.get()).m_46749_(msg.blockEntityPos)) {
                    return;
                }
                BlockEntity blockEntity = ((Level)world.get()).m_7702_(msg.blockEntityPos);
                if (blockEntity instanceof ItemMoldBlockEntity) {
                    ItemMoldBlockEntity mold = (ItemMoldBlockEntity)blockEntity;
                    mold.setInputFluid(msg.fluidResult);
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("BlockEntityFluidToClient received on server.");
        }
    }
}

