/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.blockentity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.block.block.anvil.TieredAnvilContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class StartSmithingToServer {
    private ResourceLocation recipeID;
    private int containerID;
    private boolean isValid;

    public StartSmithingToServer(ResourceLocation recipeID, int containerID) {
        this.recipeID = recipeID;
        this.containerID = containerID;
        this.isValid = true;
    }

    private StartSmithingToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130085_(this.recipeID);
            b.writeInt(this.containerID);
        }
    }

    public static StartSmithingToServer read(FriendlyByteBuf b) {
        StartSmithingToServer msg = new StartSmithingToServer();
        msg.recipeID = b.m_130281_();
        msg.containerID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(StartSmithingToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("StartSmithingToServer received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                if (player.m_6084_()) {
                    ctx.enqueueWork(() -> StartSmithingToServer.doServerWork(msg, player));
                }
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null or dead.");
            }
        }
    }

    private static void doServerWork(StartSmithingToServer msg, ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player.f_36096_.f_38840_ == msg.containerID && !player.m_5833_() && (abstractContainerMenu = player.f_36096_) instanceof TieredAnvilContainer) {
            TieredAnvilContainer container = (TieredAnvilContainer)abstractContainerMenu;
            if (player.f_19853_.m_46749_(container.entity.m_58899_()) && container.entity.m_58899_().m_203198_(player.m_20185_(), player.m_20186_(), player.m_20189_()) <= 25.0 && container.entity.canStartSmithing((Player)player, msg.recipeID)) {
                container.consumeInputs();
                container.entity.startSmithing(msg.recipeID);
                player.f_36096_.m_38946_();
            }
        }
    }
}

