/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ActionToClient {
    private ResourceLocation actionID;
    private int entityID;
    private boolean isValid;

    public ActionToClient(ResourceLocation actionID, int entityID) {
        this.entityID = entityID;
        this.actionID = actionID;
        this.isValid = true;
    }

    private ActionToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.entityID);
            b.m_130085_(this.actionID);
        }
    }

    public static ActionToClient read(FriendlyByteBuf b) {
        ActionToClient msg = new ActionToClient();
        msg.entityID = b.readInt();
        msg.actionID = b.m_130281_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ActionToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (!msg.isValid) {
            Nightfall.LOGGER.warn("ActionToClient is invalid.");
            return;
        }
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("Level could not be found.");
                    return;
                }
                Entity entity = ((Level)world.get()).m_6815_(msg.entityID);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    IActionTracker capA = ActionTracker.get((Entity)livingEntity);
                    capA.startAction(msg.actionID);
                } else {
                    Nightfall.LOGGER.warn("Entity is not an instance of LivingEntity.");
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("ActionToClient received on server.");
        }
    }
}

