/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.ActionToClient;
import frostnox.nightfall.network.message.capability.ActionTrackerToClient;
import frostnox.nightfall.registry.ActionsNF;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ActionToServer {
    private boolean mainHand;
    private ResourceLocation actionID;
    private boolean isValid;

    public ActionToServer(boolean mainHand, ResourceLocation actionID) {
        this.mainHand = mainHand;
        this.actionID = actionID;
        this.isValid = true;
    }

    private ActionToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeBoolean(this.mainHand);
            b.m_130085_(this.actionID);
        }
    }

    public static ActionToServer read(FriendlyByteBuf b) {
        ActionToServer msg = new ActionToServer();
        msg.mainHand = b.readBoolean();
        msg.actionID = b.m_130281_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ActionToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (!msg.isValid) {
            Nightfall.LOGGER.warn("ActionToServer is invalid.");
            return;
        }
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("ActionToServer received on client.");
        } else if (sideReceived.isServer()) {
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                ctx.enqueueWork(() -> ActionToServer.doServerWork(msg, player));
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null.");
            }
        }
    }

    private static void doServerWork(ActionToServer msg, ServerPlayer player) {
        if (!player.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        Item item = player.m_21205_().m_41720_();
        if (!msg.mainHand) {
            item = player.m_21206_().m_41720_();
        }
        if (item instanceof IActionableItem) {
            IActionableItem actionableItem = (IActionableItem)item;
            if (msg.mainHand) {
                capP.setMainhandActive();
            } else {
                capP.setOffhandActive();
            }
            if (!ActionsNF.get(msg.actionID).canStart((LivingEntity)player) || !actionableItem.hasAction(msg.actionID, (Player)player)) {
                capA.dequeue();
                NetworkHandler.toClient(player, new ActionTrackerToClient(capA.writeNBT(), player.m_142049_()));
            } else {
                capA.startAction(msg.actionID);
                NetworkHandler.toAllTracking((Entity)player, new ActionToClient(capA.getActionID(), player.m_142049_()));
            }
        }
    }
}

