/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ActionTrackerToClient {
    private final CompoundTag NBT;

    public ActionTrackerToClient(CompoundTag NBT, int entityID) {
        NBT.m_128405_("entityid", entityID);
        this.NBT = NBT;
    }

    private ActionTrackerToClient(CompoundTag NBT) {
        this.NBT = NBT;
    }

    public static void write(ActionTrackerToClient msg, FriendlyByteBuf b) {
        b.m_130079_(msg.NBT);
    }

    public static ActionTrackerToClient read(FriendlyByteBuf b) {
        return new ActionTrackerToClient(b.m_130260_());
    }

    public static void handle(ActionTrackerToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> ActionTrackerToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("ActionTrackerToClient received on server.");
        }
    }

    private static void doClientWork(ActionTrackerToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.NBT.m_128451_("entityid"));
        if (!(entity instanceof LivingEntity)) {
            Nightfall.LOGGER.warn("Entity is invalid.");
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (!entity2.m_6084_()) {
            Nightfall.LOGGER.warn("LivingEntity is null or dead.");
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)entity2);
        capA.readNBT(msg.NBT);
    }
}

