/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.PlayerAttribute;
import frostnox.nightfall.registry.forge.AttributesNF;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class AttributeSelectionToServer {
    private EnumMap<PlayerAttribute, Integer> attributes;
    private boolean isValid;

    public AttributeSelectionToServer(EnumMap<PlayerAttribute, Integer> attributes) {
        this.isValid = true;
        this.attributes = attributes;
        if (attributes.size() != PlayerAttribute.values().length) {
            this.isValid = false;
        } else {
            int sum = 0;
            for (Integer points : attributes.values()) {
                sum += points.intValue();
                if (points >= -3 && points <= 3) continue;
                this.isValid = false;
                break;
            }
            if (sum > 0) {
                this.isValid = false;
            }
        }
    }

    private AttributeSelectionToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            for (Integer points : this.attributes.values()) {
                b.m_130130_(points.intValue());
            }
        }
    }

    public static AttributeSelectionToServer read(FriendlyByteBuf b) {
        if (!b.isReadable(PlayerAttribute.values().length)) {
            return new AttributeSelectionToServer();
        }
        EnumMap<PlayerAttribute, Integer> attributes = new EnumMap<PlayerAttribute, Integer>(PlayerAttribute.class);
        for (PlayerAttribute attribute : PlayerAttribute.values()) {
            attributes.put(attribute, b.m_130242_());
        }
        return new AttributeSelectionToServer(attributes);
    }

    public static void handle(AttributeSelectionToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("AttributeSelectionToServer received on client.");
        } else if (sideReceived.isServer()) {
            if (!msg.isValid) {
                return;
            }
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                if (player.m_6084_()) {
                    ctx.enqueueWork(() -> AttributeSelectionToServer.doServerWork(msg, player));
                }
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null or dead.");
            }
        }
    }

    private static void doServerWork(AttributeSelectionToServer msg, ServerPlayer player) {
        IPlayerData capP = PlayerData.get((Player)player);
        for (PlayerAttribute attribute : msg.attributes.keySet()) {
            capP.setAttributePoints(attribute, msg.attributes.get((Object)attribute));
        }
        capP.setNeedsAttributeSelection(false);
        player.m_21153_(player.m_21233_());
        capP.setStamina(AttributesNF.getMaxStamina((Player)player));
    }
}

