/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class EncyclopediaKnowledgeToClient {
    private ResourceLocation id;
    private boolean remove;
    private int entityID;
    private boolean isValid;

    public EncyclopediaKnowledgeToClient(ResourceLocation id, boolean remove, int entityID) {
        this.id = id;
        this.remove = remove;
        this.entityID = entityID;
        this.isValid = true;
    }

    private EncyclopediaKnowledgeToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130085_(this.id);
            b.writeBoolean(this.remove);
            b.writeInt(this.entityID);
        }
    }

    public static EncyclopediaKnowledgeToClient read(FriendlyByteBuf b) {
        EncyclopediaKnowledgeToClient msg = new EncyclopediaKnowledgeToClient();
        msg.id = b.m_130281_();
        msg.remove = b.readBoolean();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(EncyclopediaKnowledgeToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> EncyclopediaKnowledgeToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("EncyclopediaKnowledgeToClient received on server.");
        }
    }

    private static void doClientWork(EncyclopediaKnowledgeToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof Player)) {
            Nightfall.LOGGER.warn("Entity is invalid.");
            return;
        }
        Player player = (Player)entity;
        if (!player.m_6084_()) {
            Nightfall.LOGGER.warn("LocalPlayer is null or dead.");
            return;
        }
        IPlayerData capP = PlayerData.get(player);
        if (msg.remove) {
            capP.removeKnowledge(msg.id);
        } else {
            capP.addKnowledge(msg.id);
        }
    }
}

