/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class EncyclopediaToClient {
    private int entityID;
    private CompoundTag NBT;
    private boolean isValid;

    public EncyclopediaToClient(CompoundTag NBT, int entityID) {
        this.entityID = entityID;
        this.NBT = NBT;
        this.isValid = true;
    }

    private EncyclopediaToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130079_(this.NBT);
            b.writeInt(this.entityID);
        }
    }

    public static EncyclopediaToClient read(FriendlyByteBuf b) {
        EncyclopediaToClient msg = new EncyclopediaToClient();
        msg.NBT = b.m_130260_();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(EncyclopediaToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> EncyclopediaToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("EncyclopediaToClient received on server.");
        }
    }

    private static void doClientWork(EncyclopediaToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof Player)) {
            Nightfall.LOGGER.warn("Entity is invalid.");
            return;
        }
        Player player = (Player)entity;
        if (!player.m_6084_()) {
            Nightfall.LOGGER.warn("LocalPlayer is null or dead.");
            return;
        }
        IPlayerData capP = PlayerData.get(player);
        capP.readEncyclopediaNBT(msg.NBT);
    }
}

