/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.registry.EntriesNF;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class EntryNotificationToServer {
    private ResourceLocation entryId;
    private boolean remove;
    private boolean isValid;

    public EntryNotificationToServer(ResourceLocation entryId, boolean remove) {
        this.entryId = entryId;
        this.remove = remove;
        this.isValid = true;
    }

    private EntryNotificationToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130085_(this.entryId);
            b.writeBoolean(this.remove);
        }
    }

    public static EntryNotificationToServer read(FriendlyByteBuf b) {
        EntryNotificationToServer msg = new EntryNotificationToServer();
        msg.entryId = b.m_130281_();
        msg.remove = b.readBoolean();
        msg.isValid = EntriesNF.contains(msg.entryId);
        return msg;
    }

    public static void handle(EntryNotificationToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn(EntryNotificationToServer.class.getSimpleName() + " received on client.");
        } else if (sideReceived.isServer()) {
            if (!msg.isValid) {
                return;
            }
            ServerPlayer player = ctx.getSender();
            if (player != null && player.m_6084_()) {
                ctx.enqueueWork(() -> EntryNotificationToServer.doServerWork(msg, player));
            }
        }
    }

    private static void doServerWork(EntryNotificationToServer msg, ServerPlayer player) {
        IPlayerData capP = PlayerData.get((Player)player);
        if (msg.remove) {
            capP.removeEntryNotification(msg.entryId);
        } else {
            capP.addEntryNotification(msg.entryId);
        }
    }
}

