/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.client.render.ContinentalEffects;
import frostnox.nightfall.world.ContinentalWorldType;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;

public class LevelDataToClient {
    private final CompoundTag NBT;

    public LevelDataToClient(CompoundTag NBT) {
        this.NBT = NBT;
    }

    public static void write(LevelDataToClient msg, FriendlyByteBuf b) {
        b.m_130079_(msg.NBT);
    }

    public static LevelDataToClient read(FriendlyByteBuf b) {
        return new LevelDataToClient(b.m_130260_());
    }

    public static void handle(LevelDataToClient msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        ctx.get().enqueueWork(() -> {
            if (!((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                Nightfall.LOGGER.error("Received LevelDataToClient on server from " + ((NetworkEvent.Context)ctx.get()).getSender().m_7755_().getString());
                return;
            }
            Level level = ((Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide())).orElse(null);
            if (level == null || !LevelData.isPresent(level)) {
                return;
            }
            ILevelData c = LevelData.get(level);
            c.readNBT(msg.NBT);
            if (msg.NBT.m_128441_("seed")) {
                c.updateWeather();
                c.updateWind();
                ((ContinentalEffects)((Object)((Object)DimensionSpecialEffects.f_108857_.get((Object)ContinentalWorldType.LOCATION)))).init(c.getSeed());
            }
            if (msg.NBT.m_128441_("weatherIntensity")) {
                c.updateWeather();
                ((ContinentalEffects)((Object)((Object)DimensionSpecialEffects.f_108857_.get((Object)ContinentalWorldType.LOCATION)))).regenClouds = true;
            }
        });
    }
}

