/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.PlayerData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ModifiableIndexToServer {
    private int index;
    private boolean isValid;

    public ModifiableIndexToServer(int index) {
        if (index < 0) {
            this.isValid = false;
        } else {
            this.index = index;
            this.isValid = true;
        }
    }

    private ModifiableIndexToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130130_(this.index);
        }
    }

    public static ModifiableIndexToServer read(FriendlyByteBuf b) {
        ModifiableIndexToServer msg = new ModifiableIndexToServer();
        if (!b.isReadable(1)) {
            return msg;
        }
        msg.index = b.m_130242_();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ModifiableIndexToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn("ModifiableIndexToServer received on client.");
        } else if (sideReceived.isServer()) {
            if (!msg.isValid) {
                return;
            }
            ServerPlayer player = ctx.getSender();
            if (player != null) {
                if (player.m_6084_()) {
                    ctx.enqueueWork(() -> ModifiableIndexToServer.doServerWork(msg, player));
                }
            } else {
                Nightfall.LOGGER.warn("ServerPlayer is null or dead.");
            }
        }
    }

    private static void doServerWork(ModifiableIndexToServer msg, ServerPlayer player) {
        PlayerData.get((Player)player).setCachedModifiableIndex(msg.index);
    }
}

