/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class PlayerDataToClient {
    private final CompoundTag NBT;

    public PlayerDataToClient(CompoundTag NBT, int entityID) {
        NBT.m_128405_("entityid", entityID);
        this.NBT = NBT;
    }

    private PlayerDataToClient(CompoundTag NBT) {
        this.NBT = NBT;
    }

    public static void write(PlayerDataToClient msg, FriendlyByteBuf b) {
        b.m_130079_(msg.NBT);
    }

    public static PlayerDataToClient read(FriendlyByteBuf b) {
        return new PlayerDataToClient(b.m_130260_());
    }

    public static void handle(PlayerDataToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> PlayerDataToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("PlayerDataToClient received on server.");
        }
    }

    private static void doClientWork(PlayerDataToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.NBT.m_128451_("entityid"));
        if (!(entity instanceof Player)) {
            Nightfall.LOGGER.warn("Entity is invalid.");
            return;
        }
        Player player = (Player)entity;
        if (!player.m_6084_()) {
            Nightfall.LOGGER.warn("LocalPlayer is null or dead.");
            return;
        }
        IPlayerData capP = PlayerData.get(player);
        capP.readNBT(msg.NBT);
    }
}

