/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.encyclopedia.EntryStage;
import frostnox.nightfall.encyclopedia.PuzzleContainer;
import frostnox.nightfall.registry.EntriesNF;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PuzzleContainerRequestToServer {
    private ResourceLocation entryId;
    private boolean isValid;

    public PuzzleContainerRequestToServer(ResourceLocation entryId) {
        this.entryId = entryId;
        this.isValid = true;
    }

    private PuzzleContainerRequestToServer() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130085_(this.entryId);
        }
    }

    public static PuzzleContainerRequestToServer read(FriendlyByteBuf b) {
        PuzzleContainerRequestToServer msg = new PuzzleContainerRequestToServer();
        msg.entryId = b.m_130281_();
        msg.isValid = EntriesNF.contains(msg.entryId);
        return msg;
    }

    public static void handle(PuzzleContainerRequestToServer msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Nightfall.LOGGER.warn(PuzzleContainerRequestToServer.class.getSimpleName() + " received on client.");
        } else if (sideReceived.isServer()) {
            if (!msg.isValid) {
                return;
            }
            ServerPlayer player = ctx.getSender();
            if (player != null && player.m_6084_()) {
                ctx.enqueueWork(() -> PuzzleContainerRequestToServer.doServerWork(msg, player));
            }
        }
    }

    private static void doServerWork(final PuzzleContainerRequestToServer msg, ServerPlayer player) {
        if (!PlayerData.get((Player)player).hasEntryStage(msg.entryId, EntryStage.PUZZLE)) {
            Nightfall.LOGGER.error("Player " + player.m_7755_().getString() + " requested puzzle container but does not have access to " + msg.entryId);
        } else {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TranslatableComponent("nightfall.encyclopedia_puzzle");
                }

                public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                    return new PuzzleContainer(pPlayerInventory, pContainerId, msg.entryId);
                }
            }, buf -> buf.m_130085_(msg.entryId));
        }
    }
}

