/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.world.inventory.AccessoryInventory;
import frostnox.nightfall.world.inventory.AccessorySlot;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SetAccessoriesToClient {
    private List<Pair<AccessorySlot, ItemStack>> accessories;
    private int entityID;
    private boolean isValid;

    public SetAccessoriesToClient(List<Pair<AccessorySlot, ItemStack>> accessories, int entityID) {
        this.accessories = accessories;
        this.entityID = entityID;
        this.isValid = true;
    }

    private SetAccessoriesToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130130_(this.entityID);
            int size = this.accessories.size();
            for (int i = 0; i < size; ++i) {
                Pair<AccessorySlot, ItemStack> pair = this.accessories.get(i);
                boolean endFlag = i != size - 1;
                int ordinal = ((AccessorySlot)((Object)pair.left())).ordinal();
                b.writeByte(endFlag ? ordinal | 0xFFFFFF80 : ordinal);
                b.m_130055_((ItemStack)pair.right());
                ++i;
            }
        }
    }

    public static SetAccessoriesToClient read(FriendlyByteBuf b) {
        byte i;
        SetAccessoriesToClient msg = new SetAccessoriesToClient();
        msg.entityID = b.m_130242_();
        AccessorySlot[] accessorySlots = AccessorySlot.values();
        msg.accessories = new ObjectArrayList(1);
        do {
            i = b.readByte();
            AccessorySlot slot = accessorySlots[i & 0x7F];
            ItemStack item = b.m_130267_();
            msg.accessories.add((Pair<AccessorySlot, ItemStack>)Pair.of((Object)((Object)slot), (Object)item));
        } while ((i & 0xFFFFFF80) != 0);
        msg.isValid = true;
        return msg;
    }

    public static void handle(SetAccessoriesToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (!msg.isValid) {
            Nightfall.LOGGER.warn("SetAccessoriesToClient is invalid.");
            return;
        }
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                Player player;
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("Level could not be found.");
                    return;
                }
                Entity entity = ((Level)world.get()).m_6815_(msg.entityID);
                if (entity instanceof Player && (player = (Player)entity).m_6084_()) {
                    IPlayerData capP = PlayerData.get(player);
                    AccessoryInventory accessories = capP.getAccessoryInventory();
                    for (Pair<AccessorySlot, ItemStack> pair : msg.accessories) {
                        accessories.setItem((AccessorySlot)((Object)((Object)pair.left())), (ItemStack)pair.right());
                    }
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("SetAccessoriesToClient received on server.");
        }
    }
}

