/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.capability;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class StatusToClient {
    private int entityID;
    private int duration;
    private Status status;
    private boolean isValid;

    public StatusToClient(int duration, int entityID, Status status) {
        this.entityID = entityID;
        this.duration = duration;
        this.status = status;
        this.isValid = true;
    }

    private StatusToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.writeInt(this.entityID);
            b.writeInt(this.duration);
            b.m_130068_((Enum)this.status);
        }
    }

    public static StatusToClient read(FriendlyByteBuf b) {
        StatusToClient msg = new StatusToClient();
        msg.entityID = b.readInt();
        msg.duration = b.readInt();
        msg.status = (Status)b.m_130066_(Status.class);
        msg.isValid = true;
        return msg;
    }

    public static void handle(StatusToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (!msg.isValid) {
            Nightfall.LOGGER.warn("StatusToClient is invalid.");
            return;
        }
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            ctx.enqueueWork(() -> {
                if (!world.isPresent()) {
                    Nightfall.LOGGER.warn("Level could not be found.");
                    return;
                }
                Entity entity = ((Level)world.get()).m_6815_(msg.entityID);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    IActionTracker capA = ActionTracker.get((Entity)player);
                    switch (msg.status) {
                        case STUN: {
                            capA.stun(msg.duration, true);
                            break;
                        }
                        case BLEEDING: {
                            capA.setBleedDuration(msg.duration);
                            break;
                        }
                        case POISON: {
                            capA.setPoisonDuration(msg.duration);
                        }
                    }
                } else if (entity instanceof ActionableEntity) {
                    ActionableEntity animEntity = (ActionableEntity)entity;
                    IActionTracker capA = animEntity.getActionTracker();
                    switch (msg.status) {
                        case STUN: {
                            capA.stun(msg.duration, true);
                            break;
                        }
                        case BLEEDING: {
                            capA.setBleedDuration(msg.duration);
                            break;
                        }
                        case POISON: {
                            capA.setPoisonDuration(msg.duration);
                        }
                    }
                } else {
                    Nightfall.LOGGER.warn("Entity does not have an ActionTracker to set status.");
                }
            });
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("StatusToClient received on server.");
        }
    }

    public static enum Status {
        STUN,
        BLEEDING,
        POISON;

    }
}

