/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.network.message.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.entity.entity.projectile.ArrowEntity;
import frostnox.nightfall.item.IProjectileItem;
import frostnox.nightfall.registry.forge.ItemsNF;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ArrowItemToClient {
    private int entityID;
    private IProjectileItem item;
    private boolean isValid;

    public ArrowItemToClient(IProjectileItem item, int entityID) {
        this.item = item;
        this.entityID = entityID;
        this.isValid = true;
    }

    private ArrowItemToClient() {
        this.isValid = false;
    }

    public void write(FriendlyByteBuf b) {
        if (this.isValid) {
            b.m_130070_(this.item.getItem().getRegistryName().toString());
            b.writeInt(this.entityID);
        }
    }

    public static ArrowItemToClient read(FriendlyByteBuf b) {
        ArrowItemToClient msg = new ArrowItemToClient();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)b.m_130277_()));
        msg.item = item instanceof IProjectileItem ? (IProjectileItem)item : (IProjectileItem)ItemsNF.FLINT_ARROW.get();
        msg.entityID = b.readInt();
        msg.isValid = true;
        return msg;
    }

    public static void handle(ArrowItemToClient msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            Optional world = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
            if (!world.isPresent()) {
                Nightfall.LOGGER.warn("ClientLevel could not be found.");
                return;
            }
            ctx.enqueueWork(() -> ArrowItemToClient.doClientWork(msg, (Level)world.get()));
        } else if (sideReceived.isServer()) {
            Nightfall.LOGGER.warn("ArrowItemToClient received on server.");
        }
    }

    private static void doClientWork(ArrowItemToClient msg, Level world) {
        Entity entity = world.m_6815_(msg.entityID);
        if (!(entity instanceof ArrowEntity)) {
            Nightfall.LOGGER.warn("Entity is invalid, expected ArrowEntity.");
            return;
        }
        ArrowEntity arrow = (ArrowEntity)entity;
        arrow.setItem(msg.item);
    }
}

